/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
#include <includes.h>



int arglist_to_file(struct arglist * , char * );
int file_to_arglist(struct arglist * , char * );



int 
arglist_to_file(hosts, filename)
 struct arglist * hosts;
 char * filename;
{
 FILE * file;
 
 file = fopen(filename, "w");
 if(!file)return(-1);
 
 while(hosts && hosts->next)
 {
  char * hostname;
  char * port;
  char * desc;
  struct arglist * ports;
  hostname = hosts->name;
  ports = arg_get_value(hosts->value, "PORTS");
  if(ports)
  {
   while(ports && ports->next)
   {
    struct arglist * report;
    struct arglist * info;
    
    port = ports->name;
    report = arg_get_value(ports->value, "REPORT");
    if(report)while(report && report->next)
     {
     char * t;
     desc = emalloc(strlen(report->value)+1);
     strncpy(desc, report->value, strlen(report->value));
     while((t = strchr(desc, '\n')))t[0]=';';
     fprintf(file,"%s %s REPORT %s\n", hostname,port, desc);
     efree(&desc);
     report = report->next;
     } 
   info = arg_get_value(ports->value, "INFO");
   if(info)while(info && info->next)
    {
     char * t;
     desc = emalloc(strlen(info->value)+1);
     strncpy(desc, info->value, strlen(info->value));
     while((t = strchr(desc, '\n')))t[0]=';';
     fprintf(file,"%s %s INFO %s\n", hostname,port, desc);
     efree(&desc);
     info = info->next;
    }
    if(!report && !info)fprintf(file, "%s %s\n", hostname, port);
    ports = ports->next;
   }
  }
  hosts = hosts->next;
 }
 fclose(file);
 return(0);
}

int 
file_to_arglist(hosts, filename)
 struct arglist * hosts;
 char * filename;
{
 FILE * fd;
 char * buf;
 
 fd = fopen(filename, "r");
 if(!fd)return(-1);
 
 buf = emalloc(4096);
 while(fgets(buf, 4095, fd) && !feof(fd))
 {
  char * buffer;
  struct arglist * host;
  struct arglist * ports;
  struct arglist * port;
  struct arglist * content;
  char * t;
  char * t2;
  char save = 0;
  
  buf[strlen(buf)-1]=0;
  t = strchr(buf, ' ');
  if(!t)continue;
  t[0]=0;
  buffer = emalloc(strlen(buf)+1);
  strncpy(buffer, buf, strlen(buf));
  t[0]=' ';
  host = arg_get_value(hosts, buffer);
  if(!host)
  {
   host = emalloc(sizeof(struct arglist));
   arg_add_value(hosts, buffer, ARG_ARGLIST, -1, host);
  }
  efree(&buffer);
  t2 = t+sizeof(char);
  t = strstr(t2, "INFO");
  if(!t)t=strstr(t2, "REPORT");
  if(t){
   t--;
   save = t[0];
   t[0] = 0;
   }
  buffer = emalloc(strlen(t2)+1);
  strncpy(buffer, t2, strlen(t2));
  if(t){
  	t[0]=save;
  	t2 = t+sizeof(char);
  	}
  ports = arg_get_value(host, "PORTS");
  if(!ports)
  {
   ports = emalloc(sizeof(struct arglist));
   arg_add_value(host, "PORTS", ARG_ARGLIST, -1, ports);
  }
  
  port = arg_get_value(ports, buffer);
  if(!port)
  {
   port = emalloc(sizeof(struct arglist));
   arg_add_value(ports, buffer, ARG_ARGLIST, -1, port);
  }
  arg_add_value(port, "STATE", ARG_INT, sizeof(int), (void*)1);
  efree(&buffer);
  
  t = strchr(t2, ' ');if(!t)continue;
  t[0] = 0;
  buffer = emalloc(strlen(t2)+1);
  strncpy(buffer, t2, strlen(t2));
  t[0] = ' ';
  t2 = t+sizeof(char);
  
  content = arg_get_value(port, buffer);
  if(!content)
  {
   content = emalloc(sizeof(struct arglist));
   arg_add_value(port, buffer, ARG_ARGLIST, -1, content);
  }
  
  t = t2;
  while((t=strchr(t, ';')))t[0]='\n';
  
  buffer = emalloc(strlen(t2)+1);
  strncpy(buffer, t2, strlen(t2));
  arg_add_value(content, "item", ARG_STRING, strlen(t2),buffer);
  bzero(buf, 4095);
 }
 efree(&buf);
 fclose(fd);
 return(0);
}
  
 

