/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Signals handler
 */

#include <includes.h>
#include "report_file.h"
#include "globals.h"

extern struct arglist * Hosts;

void 
sighand_pipe()
{
  fprintf(stderr, "Connection closed by the server (SIGPIPE caught)\n");
  shutdown(0,2);
  close(0);
  _exit(1);   
}


void 
sighand_sigsegv()
{
 signal(SIGSEGV, exit);
 fprintf(stderr, "ERROR ! SIGSEGV Caught !\n");
 if(Hosts)
 {
  arglist_to_file(Hosts, "nessus_test_dump.nsr");
  fprintf(stderr, "Current test saved as 'nessus_test_dump.nsr'\n");
 }
 exit(1);
}

void 
sighand_alarm()
{
  fprintf(stderr, "Connection timed out\n");
  shutdown(0,2);
  close(0);
  _exit(1);
}
 
