/*
 * this function is fnmatch()
 */
/* Copyright (C) 1991, 1992, 1993 Free Software Foundation, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <errno.h>
#include <ctype.h>


#define	NESSUS_FNM_NOMATCH	1	/* Match failed. */

#define	NESSUS_FNM_NOESCAPE	0x01	/* Disable backslash escaping. */
#define	NESSUS_FNM_PATHNAME	0x02	/* Slash must be matched by slash. */
#define NESSUS_FNM_FILE_NAME	0x02
#define	NESSUS_FNM_PERIOD	0x04	/* Period must be matched by period. */
#define	NESSUS_FNM_LEADING_DIR	0x08	/* Ignore /<tail> after Imatch. */
#define	NESSUS_FNM_CASEFOLD	0x10	/* Case insensitive search. */
#define	NESSUS_FNM_IGNORECASE	NESSUS_FNM_CASEFOLD

/* Match STRING against the filename pattern PATTERN, returning zero if
   it matches, nonzero if not.  */
int
nessus_fnmatch (pattern, string, flags)
     const char *pattern;
     const char *string;
     int flags;
{
  register const char *p = pattern, *n = string;
  register char c;

/* Note that this evalutes C many times.  */
#define FOLD(c)	((flags & NESSUS_FNM_CASEFOLD) && isupper (c) ? tolower (c) : (c))

  while ((c = *p++) != '\0')
    {
      c = FOLD (c);

      switch (c)
	{
	case '?':
	  if (*n == '\0')
	    return NESSUS_FNM_NOMATCH;
	  else if ((flags & NESSUS_FNM_FILE_NAME) && *n == '/')
	    return NESSUS_FNM_NOMATCH;
	  else if ((flags & NESSUS_FNM_PERIOD) && *n == '.' &&
		   (n == string || ((flags & NESSUS_FNM_FILE_NAME) && n[-1] == '/')))
	    return NESSUS_FNM_NOMATCH;
	  break;

	case '\\':
	  if (!(flags & NESSUS_FNM_NOESCAPE))
	    {
	      c = *p++;
	      c = FOLD (c);
	    }
	  if (FOLD (*n) != c)
	    return NESSUS_FNM_NOMATCH;
	  break;

	case '*':
	  if ((flags & NESSUS_FNM_PERIOD) && *n == '.' &&
	      (n == string || ((flags & NESSUS_FNM_FILE_NAME) && n[-1] == '/')))
	    return NESSUS_FNM_NOMATCH;

	  for (c = *p++; c == '?' || c == '*'; c = *p++, ++n)
	    if (((flags & NESSUS_FNM_FILE_NAME) && *n == '/') ||
		(c == '?' && *n == '\0'))
	      return NESSUS_FNM_NOMATCH;

	  if (c == '\0')
	    return 0;

	  {
	    char c1 = (!(flags & NESSUS_FNM_NOESCAPE) && c == '\\') ? *p : c;
	    c1 = FOLD (c1);
	    for (--p; *n != '\0'; ++n)
	      if ((c == '[' || FOLD (*n) == c1) &&
		  nessus_fnmatch (p, n, flags & ~NESSUS_FNM_PERIOD) == 0)
		return 0;
	    return NESSUS_FNM_NOMATCH;
	  }

	case '[':
	  {
	    /* Nonzero if the sense of the character class is inverted.  */
	    register int not;

	    if (*n == '\0')
	      return NESSUS_FNM_NOMATCH;

	    if ((flags & NESSUS_FNM_PERIOD) && *n == '.' &&
		(n == string || ((flags & NESSUS_FNM_FILE_NAME) && n[-1] == '/')))
	      return NESSUS_FNM_NOMATCH;

	    not = (*p == '!' || *p == '^');
	    if (not)
	      ++p;

	    c = *p++;
	    for (;;)
	      {
		register char cstart = c, cend = c;

		if (!(flags & NESSUS_FNM_NOESCAPE) && c == '\\')
		  cstart = cend = *p++;

		cstart = cend = FOLD (cstart);

		if (c == '\0')
		  /* [ (unterminated) loses.  */
		  return NESSUS_FNM_NOMATCH;

		c = *p++;
		c = FOLD (c);

		if ((flags & NESSUS_FNM_FILE_NAME) && c == '/')
		  /* [/] can never match.  */
		  return NESSUS_FNM_NOMATCH;

		if (c == '-' && *p != ']')
		  {
		    cend = *p++;
		    if (!(flags & NESSUS_FNM_NOESCAPE) && cend == '\\')
		      cend = *p++;
		    if (cend == '\0')
		      return NESSUS_FNM_NOMATCH;
		    cend = FOLD (cend);

		    c = *p++;
		  }

		if (FOLD (*n) >= cstart && FOLD (*n) <= cend)
		  goto matched;

		if (c == ']')
		  break;
	      }
	    if (!not)
	      return NESSUS_FNM_NOMATCH;
	    break;

	  matched:;
	    /* Skip the rest of the [...] that already matched.  */
	    while (c != ']')
	      {
		if (c == '\0')
		  /* [... (unterminated) loses.  */
		  return NESSUS_FNM_NOMATCH;

		c = *p++;
		if (!(flags & NESSUS_FNM_NOESCAPE) && c == '\\')
		  /* XXX 1003.2d11 is unclear if this is right.  */
		  ++p;
	      }
	    if (not)
	      return NESSUS_FNM_NOMATCH;
	  }
	  break;

	default:
	  if (c != FOLD (*n))
	    return NESSUS_FNM_NOMATCH;
	}

      ++n;
    }

  if (*n == '\0')
    return 0;

  if ((flags & NESSUS_FNM_LEADING_DIR) && *n == '/')
    /* The NESSUS_FNM_LEADING_DIR flag says that "foo*" matches "foobar/frobozz".  */
    return 0;

  return NESSUS_FNM_NOMATCH;
}
