/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Plugins Inter Communication
 * -   -   -     -
 *
 * This set of functions just read what the plugin writes on its pipe,
 * and put it in an arglist
 */ 
 
#include <includes.h>
#include "piic.h"
void 
piic_parse(args, pip, buf)
 struct arglist * args;
 int pip;
 char * buf;
{
 char * t;
 int type;
 if(buf[strlen(buf)-1]=='\n')buf[strlen(buf)-1]=0;
 t = strchr(buf, ' ');
 if(!t)return;
 t[0] = 0;
 type = atoi(buf);
 t[0] = ' ';
 if(type != ARG_ARGLIST){
  char * value = strrchr(buf, '=');
  char * copy;
  if(!value)return;
  
  value[0]=0;value+=sizeof(char);
  if(type==ARG_STRING)
   {
   copy = estrdup(value);
   arg_add_value(args, t+sizeof(char), ARG_STRING, strlen(copy), copy);
   }
  if(type==ARG_INT)
   arg_add_value(args, t+sizeof(char), ARG_INT, sizeof(int), (void *)atoi(value));
  }
 else piic_arglist(args, pip, buf);
}


void
piic_arglist(args, pip, buf)
 struct arglist * args;
 int pip;
 char * buf;
{
 char * end = strrchr(buf, '/');
 struct arglist * arglist = emalloc(sizeof(struct arglist));
 int finished = 0;
 if(!end)return;
 end[0] = 0;
 while(!finished)
 {
  char * buffer = emalloc(255);
  recv_line(pip, buffer, 255);
  finished = (strstr(buffer, "/END_AL"))?1:0;
  piic_parse(arglist, pip, buffer);
  efree(&buffer);
 }
 arg_add_value(args, buf, ARG_ARGLIST, -1, arglist);
}
