/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */  
 
#ifndef _NESSUS_RULES_H
#define _NESSUS_RULES_H

struct nessus_rules
	{
	char * name;
	int category; 
	int server; /* server rules ? */
        int user;   /* rules of the user */
        int extra;  /* extra rules */
	int extra_flag;
	struct nessus_rules * next;
	};
	
#define p_NOTHING 0	/*      nothing					*/
#define p_DONT_TEST 2	/*	n:hostname				*/
#define p_DO_TEST 4	/*	y:hostname -- bypasses DONT_TEST	*/
#define p_DO_NOT_TEST 8 /*	y:!hostname -- bypasses DO_TEST		*/

#define noRule(a)   (a==0)
#define dontTest(a) (a & p_DONT_TEST)
#define doTest(a)   (a & p_DO_TEST)
#define do_notTest(a) (a & p_DO_NOT_TEST)
#define pTEST(a) (noRule(a) || ((!dontTest(a) || doTest(a))&&(!do_notTest(a))))
void rules_init(struct nessus_rules **, struct arglist *);
void rules_add(struct nessus_rules *, char *, int);
struct nessus_rules * rules_parse(char * , struct nessus_rules *, int);
short get_hostname_attributes(struct arglist *, char *);
void rules_dup(struct nessus_rules *, struct nessus_rules *);

#endif
