/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Signals handlers
 */

#include <includes.h>


#ifndef NESSUSNT
#include "log.h"
#include "auth.h"
#include "threads.h"
#include "sighand.h"


void sighand_pipe()
{
  log_write("connection closed by the client (SIGPIPE caught)\n");
  shutdown(0,2);
  close(0);
  _EXIT(1);   
}

void sighand_chld()
{
  wait(NULL);
}


void sighand_alarm()
{
  log_write("connection timed out\n");
  shutdown(0,2);
  close(0);
  _EXIT(1);
}           


void sighand_term()
{
  log_write("received the TERM signal\n");
#ifndef USE_AF_INET
  unlink(AF_UNIX_PATH);
#endif
  EXIT(0);
}
 
void sighand_int()
{
 log_write("received the INT signal\n");
#ifndef USE_AF_INET
 unlink(AF_UNIX_PATH);
#endif
 EXIT(0);
}

void sighand_segv()
{
 signal(SIGSEGV, exit);
 log_write("SIGSEGV occured !\n");
#ifndef USE_AF_INET
 unlink(AF_UNIX_PATH);
#endif
 exit(0);
}

void sighand_kill()
{
 log_write("received the KILL signal\n");
#ifndef USE_AF_INET
  unlink(AF_UNIX_PATH);
#endif
  exit(0);
}

#endif /* not defined(NESSUSNT) */
