/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * sniffer.c : 
 *  layer between the plugins and the libpcap
 *
 */
 
#include <pcap.h>


char * init_sniffer(struct arglist *, char *);
void sniffer_thread(struct arglist *, int, int);



char *
init_sniffer(vars,interface_name)
 struct arglist * vars; /* sniffer variables */
 char * ifname;
{
 char errbuf[PCAP_ERRBUF_SIZE];
 long localnet;
 long netmask;
 pcap_t * pcap;
 
 pcap = pcap_open_live(ifname, 1500, 1, 20, errbuf);
 if(!pcap)return(errbuf);
 
 if(pcap_lookupnet(ifname, &localnet, &netmask, errbuf)<0)
 {
  fprintf(stderr, "nessusd : failed to lookup the device netmask\n");
  return(errbuf);
 }
 
 arg_add_value(vars, "pcap", ARG_PTR, -1, pcap);
 arg_add_value(vars, "localnet", ARG_INT, sizeof(long), localnet);
 arg_add_value(vars, "netmask", ARG_INT, sizeof(long), netmask);
 
 /* the job of this function stops here */
 return(NULL);
}


void
sniffer_add_filter(vars, filter)
 struct arglist * vars;


