/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Users manager
 *
 */
 
#include <includes.h>
#ifdef NESSUSNT
#include "wstuff.h"
#endif
#include "log.h"
#include "users.h"

int users_init(struct users ** users, struct arglist * preferences)
{
 FILE * fd;
 char * fname;
 char * str;
 struct users * l_users;

#ifdef DEBUG_LOG
    log_write("debug: -> users_init\n");
#endif

 *users = emalloc(sizeof(struct users));
 l_users = *users;
 fname = arg_get_value(preferences, "users");
 if(!fname)
 {
   print_error("\"users\" not set in %s\n",
   		(const char *) arg_get_value(preferences, "config_file"));
   print_error("now exiting...\n");
   DO_EXIT(1);
 }
 fd = fopen(fname, "r");
 if(!fd)
 {
#ifndef NESSUSNT
   if(errno != ENOENT)
    {
     print_error("%s could not be opened -- now exiting\n", fname);
     DO_EXIT(1);
    }
   else
   { 
#endif
#ifndef NESSUSNT
   int f;
   if((f = open(fname, O_CREAT | O_WRONLY | O_EXCL, 0600))==-1)
#else
   FILE * f;
   if((f = fopen(fname, "w"))==NULL)
#endif
    {
    print_error("could not create the file %s -- now exiting\n", fname);
    DO_EXIT(1);
    }
#ifndef NESSUSNT
   write(f, "# user password rules;\nfoo pass y:*;\n", 37);
   close(f);
#else
   fprintf(f, "# user password rules;\nfoo pass y:*;\n");
   fclose(f);
#endif
   print_error("\
A new user database (%s) has been created\n\
You must edit it and then relaunch nessusd\n", fname);
   DO_EXIT(0);
#ifndef NESSUSNT
   }
#endif
 }
 
 str = emalloc(1024);
 while(fgets(str, 1023, fd) && !feof(fd))
 {
  char * user;
  char * password;
  char * perms_str;
  char * t;
  
  if(str[0]!='#')
  {
  user = emalloc(strlen(str)+1);
  password = emalloc(strlen(str)+1);
  perms_str = emalloc(strlen(str)+1);
  sscanf(str, "%s %s %s", user, password, perms_str);
  l_users->name = emalloc(strlen(user)+1);
  strncpy(l_users->name, user, strlen(user));
  l_users->password = emalloc(strlen(password)+1);
  strncpy(l_users->password, password, strlen(password));
  t = perms_str;
  while((t=strchr(t, ';')))t[0]='\n';
  l_users->perms = emalloc(strlen(perms_str)+1);
  strncpy(l_users->perms, perms_str, strlen(perms_str));
#ifdef DEBUG_LOG
    log_write("debug: -- users_init: Found user '%s', password '%s', perms '%s'\n",
	      user, password, perms_str);
#endif
  l_users->next = emalloc(sizeof(struct users));
  l_users = l_users->next;
  }
  else bzero(str, 1024);
  }
  fclose(fd);

#ifdef DEBUG_LOG
    log_write("debug: <- users_init\n");
#endif

  return(0);
}

char * 
check_user(struct users * users, char * user, char * password)
{
  char* result;

#ifdef DEBUG_LOG
    log_write("debug: -> check_user: user = '%s', password = '%s'\n",
	      user, password);
#endif

 while(users && users->next)
 {
  if(!strcmp(user, users->name))break;
  users = users->next;
 }
 
 if (!users || !users->next || strcmp(users->password, password))
   result = NULL;
 else
   result = users->perms;

#ifdef DEBUG_LOG
 log_write("debug: <- check_user: result = %s\n", result ? result : "NULL");
#endif

 return(result);
}
 
 
 
