/* Nessuslib -- the Nessus Library
 * Copyright (C) 1998 Renaud Deraison
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */   

#ifndef _NESSUSD_UTILS_H
#define _NESSUSD_UTILS_H

struct arglist * sort_plugins_by_type(struct arglist *);
int get_max_thread_number(struct arglist *);
int get_active_plugins_number(struct arglist *);
void plugins_set_ntp_caps(struct arglist *, ntp_caps*);
void send_plugin_order(struct arglist *, struct arglist *);
void check_client_input(struct arglist *);
void check_client_input_thread(struct arglist *);
int is_symlink(char *);
void check_symlink(char *);
#endif
