/* Nessuslib -- the Nessus Library
 * Copyright (C) 1998 Renaud Deraison
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#define EXPORTING
#include <includes.h>
#include "system.h"


ExtFunc
void * emalloc(size)
 size_t size;
{
    void * ptr;
	
    ptr = malloc(size);
    if(!ptr){
	fprintf(stderr, "Could not allocate a pointer !\n");
	exit(1);
	}
    bzero(ptr, size);
    return(ptr);
}


ExtFunc
char * estrdup(str)
 const char * str; 
{
    char * buf;
    if (!str) return NULL;
    buf = malloc(strlen(str)+1);
    strncpy(buf, str, strlen(str)+1);
    return buf;
}


ExtFunc
void efree(ptr)
 void * ptr;
{
    char ** p = ptr;
    if(p && *p)free(*p);
    *p=NULL;
}


ExtFunc
size_t estrlen(s,n)
 const char * s; 
 size_t n;
{
    size_t i;
    for(i = 0; (*(s+i) != '\0' && i < n); i++);
    return i;
}
