
#include <includes.h>


#define AUTOFS_PROG			100099


#define NAME "Solaris Automountd exploit"
#define DESC "\
There is a flaw in the Solaris rpc.statd\n\
and automountd which may allow an intruder\n\
to execute any command remotely as root.\n\
This plugin warns the user that automountd\n\
is enabled but **DOESN'T TEST IF THE VULNERABILITY\
IS PRESENT**.\n\
Risk factor : High"

#define COPYRIGHT "written after the advisory of Corruptio Optimi Pessima"
#define SUMM "Checks if automountd is enabled"


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
        plug_set_name(desc, NAME);
        plug_set_description(desc, DESC);
        plug_set_summary(desc, SUMM);
        plug_set_copyright(desc, COPYRIGHT);
        plug_set_category(desc, ACT_ATTACK);
        plug_set_family(desc, "Gain root remotely");
        return(0);
}

PlugExport int plugin_run(struct arglist * desc);
PlugExport int plugin_run(struct arglist * desc)
{
  int port;
   if(plug_get_key(desc, "rpc/portmapper")&&
     (strlen(plug_get_key(desc, "rpc/portmapper"))<3))return(0);
  port = getrpcport(plug_get_hostname(desc), AUTOFS_PROG, -1, IPPROTO_UDP);
  if(port)post_hole_udp(desc,port,
"The remote host *may* be vulnerable to\n\
the automountd bug, but we could not test\n\
it.\n\
Solution : contact your vendor and ask if\n\
your setup is vulnerable");

}
