/*
 * bootparamd
 *
 * This plugin is distributed under the GPL
 */


#include <includes.h>
#ifdef HAVE_RPC_RPC_H
#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h>
#endif

#define BOOTPARAM_RPC 100026

#define NAME "Bootparamd presence check"
#define DESC "\
When  a  diskless  client  needs  to  boot,  it uses the bootparam\n\
protocol to get the necessary information needed from the  server.\n\
If bootparamd is running one can guess at which is the client  and\n\
server  or  use  a  program  such as bootparam_prot.x to determine\n\
which is which.\n\
\n\
If an intruder uses BOOTPARAMPROC_WHOAMI and provides the  address\n\
of  the  client,  he  will  get  it's  NIS  domain  name back from\n\
bootparamd.  If you know the  NIS domain name, it may be  possible\n\
to get a copy of the password file.\n\
One solution would be to filter incoming connections to port 111\n\
(portmap)\n\
Risk factor : High"

#define SUMMARY "check for the presence of the bootparam RPC service"
#define COPYRIGHT "no copyright"

PlugExport int plugin_init(struct arglist * desc);
PlugExport int plugin_init(struct arglist * desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESC);
  plug_set_summary(desc, SUMMARY);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_ATTACK);
  plug_set_family(desc, "NIS");
  plug_set_timeout(desc, 10);
  return(0);
}



PlugExport int plugin_run(struct arglist * env);
PlugExport int plugin_run(struct arglist * env)
{
  if(plug_get_key(env, "rpc/portmapper")&&
     (strlen(plug_get_key(env, "rpc/portmapper"))<3))return(0);
 if (callrpc (plug_get_hostname(env), BOOTPARAM_RPC, -1, 0,
		       (xdrproc_t) xdr_void, (caddr_t) NULL,
		       (xdrproc_t) xdr_void, (caddr_t) NULL) == 9)
 {
  int port;
  port = getrpcport(plug_get_hostname(env), BOOTPARAM_RPC, 1,IPPROTO_UDP);
  if(!port)port = -1;
  post_hole_udp(env, port, "\
The remote host is running bootparamd.\n\
If an intruder guesses the name of one of\n\
the bootparamd clients, he may be able to\n\
get the domain name and then the passwd file.\n\
Solution : filter incoming connections to port 111");
 }
 return(0);
}
