/*
 * 
 * cgi_perl
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>
#define NAME "perl interpreter can be launched as a CGI"
#define DESC "\
Some badly configured web servers allow the users to execute\n\
the perl interpreter, which is not a good thing, since it is\n\
like giving a shell access to anyone. Removing the perl executable\n\
from the 'cgi-bin' directory solves this problem\n\n\
Risk factor : high"
#define COPYRIGHT "no copyright"
#define SUMM "determines if the perl interpreter can be launched as a cgi"

static int 
installed(data, cgi_name)
 struct arglist * data;
 char * cgi_name;
{
 char * command = emalloc(200);
 short soc=-1;
 short i=0;
 char * buff = emalloc(256);
  
 sprintf(command, "GET /cgi-bin/%s HTTP/1.0\nhostname: %s\n\n",
          cgi_name,  plug_get_hostname(data));
          
 soc = open_sock_tcp(data, 80);
 if(soc <0)return(0); /* couldn't open a connection */
 send(soc, command, strlen(command), 0);
 recv(soc, buff, 255,0);
 efree(&command);
 close(soc);
 
 if(strstr(buff, "HTTP/1.0 200 ") || strstr(buff, "HTTP/1.1 200 ") ||
   strstr(buff, "HTTP/1.0 500 ") || strstr(buff, "HTTP/1.1 500 "))i=1;
 else i = 0;
 efree(&buff);
 return(i);
}


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_ATTACK);
	plug_set_family(desc, "CGI abuses");
	return(0);
}


PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	if(!host_get_port_state(args, 80))return(0);
	if(installed(args, "perl")||installed(args, "perl.exe"))
        {
         post_hole(args, 80, 
"The remote web server allows the execution of the\n\
perl interpreter, which is like giving a shell access\n\
to anyone\n\n\
Solution: remove the 'perl' (or 'perl.exe') binary from\n\
the cgi-bin directory of the HTTP server");
       }
	return(0);
}

