/*
 * 
 * daytime
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>


#define NAME "daytime check"
#define DESC "\
This plugin determines if the daytime service is running.\n\
Sometimes, the date format issued by this service can help\n\
an intruder to guess the operating system of the remote host.\n\
This service is potentially vulnerable to spoofing attacks\n\
which can link the daytime port to the echo port\n\
consuming network bandwidth.\n\
You should disable this service if you do not use it\n\
Risk factor : low"
#define COPYRIGHT "no copyright"
#define SUMM "determines if daytime is activated"



PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{

	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "Misc.");
	return(0);
}


PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	char * report = emalloc(1024);
        int sock;
        sprintf(report, "\
The daytime service is running.\n\
Sometimes, the date format issued by this service can help\n\
an intruder to guess the operating system of the remote host.\n\
This service is potentially vulnerable to spoofing attacks\n\
which can link the daytime port to the echo port\n\
consuming network bandwidth.\n\
Solution: comment out the daytime line in /etc/inetd.conf");
 	if(host_get_port_state(args, 13)>0)
        {
	 sock = open_sock_tcp(args, 13);
         if(sock > 0)post_info(args, 13, report);
         close(sock);
         }
         
        sock = socket(AF_INET, SOCK_DGRAM, 0);
        if(sock > 0)
        {
         struct sockaddr_in addr;
         struct in_addr * ip;
         char * buff = emalloc(150);
         int len;
         fd_set read;
         struct timeval to ={10,0};
         ip = plug_get_host_ip(args);
         addr.sin_addr = *ip;
         addr.sin_port = htons(13);
         addr.sin_family = AF_INET;
         sendto(sock, buff, 150, 0,(struct sockaddr *)&addr, sizeof(addr));
         FD_ZERO(&read);
         FD_SET(sock, &read);
         select(sock+1, &read, NULL, NULL, &to);
         if(FD_ISSET(sock, &read))
         {
          recvfrom(sock, buff, 150, 0,(struct sockaddr *)&addr, &len);
          if(strlen(buff))post_info_udp(args, 13, report);
         }
         efree(&buff);
        }
        efree(&report);
        return(0);
}
         






