/*
 * 
 * finger
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>

#define NAME "finger redirection check"
#define DESC "\
This plugin attempts to bounce a remote finger request\n\
through the target-host finger daemon. A request of the form :\n\
	user@host2@target\n\
is made. If your finger daemon allows this kind of\n\
request, your host may be used by an attacker as a \n\
relay to gather informations about a third-party\n\
host.\n\
Solution : disable your finger daemon or replace it \n\
by a more secure one"

#define COPYRIGHT "no copyright"
#define SUMM "checks whether the remote finger accepts requests like user@host1@target"
 


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "finger abuses");
	return(0);
}


PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	
	int soc;
	char * buffer;
	
	if(host_get_port_state(args, 79)<=0)return(0);  
	soc = open_sock_tcp(args, 79);
	if(soc < 0)return(0);
	buffer = emalloc(1024);
	sprintf(buffer, "root@%s@%s\n", plug_get_hostname(args), 
		plug_get_hostname(args));
	send(soc, buffer, strlen(buffer),0);
	bzero(buffer,1024);
	recv(soc, buffer, 1023,0);
	socket_close(soc);
	if(strlen(buffer) && !strstr(buffer, "forward")&&!strstr(buffer, "???")&&
		!strstr(buffer, "doesn't exist") && !strstr(buffer, "Welcome to")) 
	{ 
	 char * report = emalloc(300+strlen(buffer));
	 sprintf(report,
	 "The remote finger accepts the redirections, ie, requests\n\
under the form : user@host1@target. This may be of some\n\
use to some attackers which can use your site as a \n\
relay to gather informations about a third-party site\n\
anonymously.\n\
Solution: disable your finger daemon or replace it by a \n\
more secure one"); 
	post_info(args, 79, report);
	} 
	efree(&buffer);
	return(0);
	
}

