/*
 * 
 * Firewall icmp.c
 *
 * This plugin attempts to send an icmp ping request to a host
 * which is supposed to be firewall-protected, and warns the user
 * if it gets a reply
 *
 * This plugin is (c) Renaud Deraison and is licensed under the GPL
 * 
 * The biggest part of this plugin has been cut'n'pasted from the hostloop library,
 * which happens to be written by me
 *
 */
 
#include <includes.h>
#ifdef HAVE_NETINET_IP_H
#include <netinet/ip.h>
#endif
#ifdef HAVE_NETINET_IP_ICMP_H
#include <netinet/ip_icmp.h>
#endif
#include "icmp.h"

#define NAME "firewall icmp check"
#define DESCRIPTION "\
Some misconfigured firewalls let icmp packets \n\
go through the network. This is a problem since \n\
the \"protected\" hosts may be subject to denial of \n\
service attacks (like the ping of death), and this \n\
may allow an intruder to insert some data inside \n\
the network, which is mostly what you want to avoid.\n\
Last but not least, it may allow an intruder to cut the\n\
connection between two hosts (sending false ICMP_UNREACH\n\
messages)\n\n\
Risk factor : medium/high"

#define COPYRIGHT "licensed under the GPL"
#define SUMMARY "attempts to insert icmp packets in a firewall-protected network"



PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESCRIPTION);
  plug_set_summary(desc, SUMMARY);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_GATHER_INFO);
  plug_set_family(desc, "Firewalls");
  return(0);
}


PlugExport int plugin_run(struct arglist * env);
PlugExport int plugin_run(struct arglist * env)
{
 char * outside = get_preference(env, "outside_firewall");
 if(outside && !strcmp(outside, "yes"))
 {
  struct in_addr * addr = plug_get_host_ip(env);
  if(addr && ping_host(*addr))
   {
    proto_post_hole(env, 0, "icmp", 
 "The remote host answered to an icmp ECHO query, even though\n\
it's protected by a firewall, which is not a good thing\n\n\
Solution : reconfigure your firewall and deny icmp traffic from\n\
the outside");
   }
 }
}


  

