/*********************************************************************\
*  Copyright (c) 1991 by Wen-King Su (wen-king@vlsi.cs.caltech.edu)   *
*                                                                     *
*  You may copy or modify this file in any manner you wish, provided  *
*  that this notice is always included, and that you hold the author  *
*  harmless for any loss or damage resulting from the installation or *
*  use of this software.                                              *
\*********************************************************************/


/****************************************************************
 * FindPort -- hack of fver to find valid ports on a FSP server *
 * by Cuda.  Yes, it's ugly, but it works for me.               *
 * Type "fspscan -h" to see how it is used.                     *
 ****************************************************************/

/*
 * Adapted to a Nessus plugin by Renaud Deraison
 *
 * This plugin is distributed under the GPL
 */

#include <includes.h>
#include "fspscan.h"

#define NAME "FSP Daemon"
#define DESC "\
This plugin checks whether a host is running an FSP daemon.\n\
FSP is a file transfer protocol similar to FTP which uses UDP to\n\
transport files.  FSP is widely used by attackers to move files\n\
from host to host.  It is also used widely by software pirates to\n\
allow easy access to caches of illicit software. \n\
\n\
If Nessus discovers that you are running a FSP daemon, you should\n\
check for the evidence of break-ins into the remote system\n\
Risk Factor: Medium"

#define COPYRIGHT "Based on the code of Wen-King Su (wen-king@vlsi.cs.caltech.edu)"
#define SUMM "Checks if the remote host has a running FSP daemon"


/* Default values */
int  localport = 9191; 
int  remoteport = 21;
int  retries = 3;
int  client_trace = 0;
int  errno;

static int myfd;
static struct sockaddr_in server_addr;
static unsigned short myseq = 0;
static unsigned short key;
int client_intr_state = 0;

static struct sockaddr_in INET_ZERO = { AF_INET };

#define DSIZE (sizeof(int)*8)
#define SAVE(A) { int sav; sav = errno; A; errno = sav; }




PlugExport int plugin_init(struct arglist * env)
{
 plug_set_name(env, NAME);
 plug_set_description(env, DESC);
 plug_set_copyright(env, COPYRIGHT);
 plug_set_summary(env, SUMM);
 plug_set_category(env, ACT_GATHER_INFO);
 plug_set_family(env, "Misc.");
 return(0);
}

PlugExport int plugin_run(struct arglist * env)
{
    int  i;
    UBUF *ub;
    init_client(plug_get_hostname(env),21,localport);
  
    ub = client_interact(CC_VERSION,0L, 0,NULLP, 0,NULLP);
   
   if(ub)post_hole_udp(env, 21, "\
An FSP daemon has been found to run on\n\
this port. The remote host may have been\n\
compromised...\n\
Solution: remove the remote FSP daemon, and check\n\
for evidences of break-ins into the remote server");
}



UBUF *client_interact(cmd,pos,l1,p1,l2,p2)
    unsigned cmd, l1, l2;
    unsigned long pos;
    unsigned char *p1, *p2;
{
    struct sockaddr_in from;
    UBUF sbuf;
    static UBUF rbuf;
    unsigned char *s, *t, *d;
    unsigned u, n, sum, mask, mlen;
    int retval, bytes, retry;

 
    sbuf.cmd = cmd;
    sbuf.len = htons(l1);
    sbuf.pos = htonl(pos);

    client_intr_state = 1;

    for(u = l1, d = (unsigned char *) sbuf.buf; u--; *d++ = *p1++);
    for(u = l2				      ; u--; *d++ = *p2++);
    mlen = d - (unsigned char *) &sbuf;

    for(retry = 0; retry < retries; retry++) {
	sbuf.key = key;
	sbuf.seq = myseq;
	sbuf.sum = 0;

	for(t = (unsigned char *) &sbuf, sum = n = mlen; n--; sum += *t++);
	sbuf.sum = sum + (sum >> 8);
	if(client_trace && retry) 
	    write(2,"R",1);

	if(sendto(myfd,&sbuf,mlen,0,(struct sockaddr *)&server_addr,sizeof(server_addr)) == -1)
        	{
                perror("Sendto : ");
		EXIT(0);		
                }		
	mask = 1 << myfd;

	while(1) {
	    retval = _x_select(&mask, 3000L);

	    if((retval == -1) && (errno = EINTR)) continue;

	    if(retval == 1) {  /* an incoming message is waiting */
		bytes = sizeof(from);
		if((bytes = recvfrom(myfd,(char*)&rbuf,sizeof(rbuf),0,
					(struct sockaddr *)&from,&bytes)) < UBUF_HSIZE) continue;

		s = (unsigned char *) &rbuf;
		d = s + bytes;
		u = rbuf.sum; rbuf.sum = 0;
		for(t = s, sum = 0; t < d; sum += *t++);
		sum = (sum + (sum >> 8)) & 0xff;
		if(sum != u) continue;  /* wrong check sum */

		rbuf.len = htons(rbuf.len);
		rbuf.pos = htonl(rbuf.pos);

		if(rbuf.seq 	      != myseq) continue;  /* wrong seq # */
		if(rbuf.len+UBUF_HSIZE > bytes) continue;  /* truncated.  */

		myseq++; key = rbuf.key;	/* update seq and keys.   */

		if(client_intr_state == 2) { 
             
                client_done(); exit(1); 
                }

		return(&rbuf);

	    } else break;   /* go back to re-transmit buffer again */
	}
    }
    /* return NULL if there have been too many retries - ffindport hack */
    return(NULL);
}


init_client(host,port,myport)
    char *host;
    int   port;
    int myport;
{
    myport = 0;
   
    if((myfd = _x_udp(&myport)) == -1)EXIT(1);
  
    if(_x_adr(host,port,&server_addr) == -1)EXIT(1);
}

client_done()
{
    (void) client_interact(CC_BYE,0L,0,NULLP,0,NULLP);
}



fdclose()
{
    close(myfd);
}


_x_udp(port)
    int *port;
{
    int f, len, zz;
    struct sockaddr_in me ;
    struct sockaddr_in sin;

    bzero(&me, sizeof(struct sockaddr_in));
    bzero(&sin, sizeof(struct sockaddr_in));
   

    me.sin_port = htons((unsigned short) *port);
    me.sin_family = AF_INET;
    me.sin_addr.s_addr = htonl(INADDR_ANY);
    if((f=socket(AF_INET,SOCK_DGRAM,0)) == -1) return(-1);
 
    if( setsockopt(f,SOL_SOCKET,SO_REUSEADDR,(int *)&zz,sizeof(zz)) < 0 ||
        bind(f,(struct sockaddr *) &me,(len = sizeof(me))) < 0)return(-1);
   return(f);
}      

_x_adr(host,port,his)
    struct sockaddr_in *his;
    char *host;
    int port;
{
    char myhost[128];
    struct hostent *H;
    int    i;
    char *s, *d;
 
    *his = INET_ZERO;
    if(!host) (void) gethostname(host = myhost,sizeof(myhost));
 
    if((his->sin_addr.s_addr = inet_addr(host)) != -1) {   
	his->sin_family = AF_INET;
    } else
    if(H = gethostbyname(host)) {   
	for(s = (char *)H->h_addr, 
	    d = (char *)&his->sin_addr, 
	    i = H->h_length; i--; *d++ = *s++);
        his->sin_family = H->h_addrtype;
    } else return(-1);
    his->sin_port = htons((unsigned short) port);
 
    return(0);
}

_x_select(rf, tt)       /* tt is in unit of ms */
    int *rf;
    long tt;
{
    struct timeval timeout;
 
    if(tt != -1)
    {
        timeout.tv_sec  =  tt / 1000;
        timeout.tv_usec = (tt % 1000)*1000;
        return(select(DSIZE, (fd_set *)rf, NULL, NULL, &timeout));
    }
       
    return(select(DSIZE, (fd_set *)rf, NULL, NULL, (struct timeval *) 0));
}



