/*
 * 
 * ftp_anonymous
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>

#define NAME "anonymous ftp enabled"
#define DESC "\
The 'ftp' service may allow anonymous logins.\n\
If the server admin decides to let this service\n\
open to the whole world, he must configure it so\n\
that anyone can not read anything on its server\n\n\
It is usually not a good idea to let a anon ftp server\n\
opened with no real reason, since many FTP attacks\n\
require the intruder to log in...\n\
Risk factor : high if the anonymous FTP is badly setted up\n\
              low if it is well configured"
              
#define COPYRIGHT "no copyright"
#define SUMM "checks if the remote ftp server accepts anonymous logins"





PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESC);
  plug_set_summary(desc, SUMM);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_GATHER_INFO);
  plug_set_family(desc, "FTP");
  return(0);
}
	


PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
 int soc;
 int vul = 0;
 
 if(host_get_port_state(args, 21)<=0)return(0);
 soc = open_sock_tcp(args, 21);
 if(soc<0)return(-1);
 if(!ftp_log_in(soc, "ftp", "joe@"))
 {
   plug_set_key(args, "ftp/anonymous_access", ARG_STRING, "yes");
   post_info(args, 21, "\
The remote FTP server accepts anonymous logins");
 }
 shutdown(soc, 2);
 close(soc);
 return(0);
}

