/*
 * 
 * ftp_bounce
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>

#define NAME "ftp bounce"
#define DESC "\
It is possible to force several FTP servers\n\
to connect to third parties hosts. This can be\n\
used by intruders to use your network resources\n\
to scan some other hosts, or it can be used to\n\
go through some firewalls\n\
Risk factor : high"
#define COPYRIGHT "no copyright"
#define SUMM "checks if the remote ftp server can be bounced"





PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESC);
  plug_set_summary(desc, SUMM);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_ATTACK);
  plug_set_family(desc, "FTP");
  return(0);
}
	


PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
 int soc;
 char * buf;
 int vul = 0;
 
 if(host_get_port_state(args, 21)<=0)return(0);
 if(!plug_get_key(args, "ftp/anonymous_access"))return(0);
 soc = open_sock_tcp(args, 21);
 if(soc<0)return(-1);
 buf = emalloc(2048);
 if(!ftp_log_in(soc, "ftp", "joe@"))
   {
     unsigned char * ip;
     struct in_addr * p = plug_get_host_ip(args);
     char * buff;
     int i;
     int ok = 0;
     
     /* we don't want our ip */
     p->s_addr++;
     ip = (unsigned char *)p;
     buff = emalloc(255);
     for(i=0;(i<3)&&!ok;i++)
       {
	 sprintf(buff, "PORT %d,%d,%d,%d,%d,%d\n", ip[0], ip[1], ip[2], ip[3], 
		 random()%255,random()%255);
	 send(soc, buff, strlen(buff), 0);
	 bzero(buff, strlen(buff));
	 recv_line(soc, buff, 255);
	 if(!strncmp(buff, "200", 3))ok = 1;
	 bzero(buff, strlen(buff));
       }
     send(soc, "QUIT\n", 5, 0);
     if(ok)vul = 1;
     efree(&buff);
   }
 efree(&buf);
 shutdown(soc, 2);
 socket_close(soc);
 
 if(vul)
   {
     post_hole(args, 21, "\
The remote FTP server is vulnerable to a bounce attack\n
This means that anyone can use it to scan some other\n\
hosts, thus making the atacked site that you were \n\
attacking it, and this allow an intruder to do several\n\
nasty other things...\n\
Solution : contact your vendor for a patch");
   }
 return(0);
}

