/*
 * 
 * ftp_realpath
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>

#define NAME "ftp real path"
#define DESC "\
It is possible to get the real path to the ftp home by issuing\n\
the 'CWD' command\n\
This information may be of some interest to an intruder who know\n\
where to put a '.rhosts' file\n\n\
Risk factor : low"
#define COPYRIGHT "no copyright"
#define SUMM "attempts to get the real path to the remote ftp home"





PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_ATTACK);
	plug_set_family(desc, "FTP");
	return(0);
}
	
void getline(int soc, char * buf)
{
 int i = 0;
 char c;
 int flag = 0;
 
 while(!flag)
 {
  read(soc, &c, 1);
  buf[i++] = c;
  if(c==0 || c=='\n' || i>4095)flag = 1;
 }
}

PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	int soc;
	char * buf;
	
	if(!plug_get_key(args, "ftp/anonymous_access"))return(0);
	if(host_get_port_state(args, 21)<=0)return(0);
	soc = open_sock_tcp(args, 21);
	if(soc<0)return(-1);
	buf = emalloc(4096);
	
	if(!ftp_log_in(soc, "ftp", "joe@"))
	{
	 bzero(buf, 4096);
	 
	 sprintf(buf, "CWD\n");
	 write(soc, buf, strlen(buf));
	 getline(soc, buf);
	 
	 if(strchr(buf,':'))
	 {
	  char * data;
	  char *t;
	  data = emalloc(strlen(buf)+255);
	  t = strchr(buf, ':');
	  if(t)t[0]=0;
	  sprintf(data,"The remote ftp home is '%s'\n\
This information may interest some system hackers who know\n\
where to put a .rhost file, although this problem is not\n\
very serious...\n\
Solution : modify the sources of your ftp daemon", buf+4);
	  if(t)t[0]=':';
	  post_info(args, 21, data);
	  efree(&data);
	 } 	
       }
        efree(&buf);
        socket_close(soc);
	return(0);
}

