/*
 * 
 * gopher_as_proxy
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>
#define NAME "Remote gopher server can be used as a proxy"
#define DESC "\
Most gopher servers accepts to act as a FTP proxy. Thus,\n\
sending a request like : ftp:any.ftp.site.com@/ to the \n\
remote gopher server will make it act as a proxy.\n\
This vulnerability can be used by attackers to bypass\n\
your firewall (if the gopher server is trusted by the\n\
firewall).\n\
In addition to that, your host may server as a launch pad\n\
to attack some other sites via FTP\n\
You should also note that gopherd offers poor logging \n\
options\n\
Risk factor : very high"
#define COPYRIGHT "Renaud Deraison <deraison@worldnet.fr>"
#define SUMM "checks for a bad gopherd"




PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_ATTACK);
	plug_set_family(desc, "Firewalls");
	return(0);
}


PlugExport int plugin_run(struct arglist * args);
PlugExport int plugin_run(struct arglist * args)
{
 int soc;
 int is_proxy = 0;
 if(host_get_port_state(args, 70)<0)return;
 soc = open_sock_tcp(args, 70);
 if(soc >= 0)
 {
  char * buf = emalloc(255);
  char * host, * bidon;
  char save;
  sprintf(buf, "ftp:%s@/\n", plug_get_hostname(args));
  send(soc, buf, strlen(buf), 0);
  bzero(buf, strlen(buf));
  recv_line(soc, buf, 255);
  host = strchr(buf, 't');
  if(host)host = strchr(host+1, '\t');
  if(host)host++;
  if(host)bidon = strchr(host, '\t');
  if(bidon){
  	save = bidon[0];
        bidon[0] = 0;
        }
  if(!strlen(host))is_proxy = 0;
  else
  {
   if(!strcmp(host, "error.host"))
   {
    /* the connection may have been refused... */
    int i;
    bidon[0] = save;
    for(i=0;i<strlen(buf);i++)buf[i]=tolower(buf[i]);
    if(strstr(buf, "connection refused"))is_proxy = 1;
   }
   else is_proxy = 1;
  }
  efree(&buf);
  }
  
 if(is_proxy)
 {
  post_hole(args, 70,
"The remote gopher server is acting as a proxy\n\
This means that anyone can do a request like\n\
ftp:any.ftp.site.com@/ and connect to the\n\
host any.ftp.site.com through your host.\n\
This may allow an intruder to bypass your firewall\n\
and this may allow an intruder to use your host\n\
as a launch pad for attacking another site\n\
Solution : disable your gopher server if it \n\
running in a firewalled environnement.\n\
And in any case, read the documentation of \n\
your gopher server to learn how to disable this\n\
feature");
 }
  return(0);
}




