/*
 * 
 * wingate
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h> 


#define NAME "HP Laserjet printer has no password"
#define DESC "\
This plugin attempts to see if the remote HP Laserjet printer\n\
has a password. A passwordless printer is a threat since it\n\
allows an attacker to change the printer's IP, thus resulting\n\
in creating network problems."
#define COPYRIGHT "no copyright"
#define SUMM "notifies the user that the remote printer has no password"


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "Misc.");
	return(0);
}


char init_telnet_session(int sock);
PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	int soc;
	char * buf;
	if(host_get_port_state(args, 23))
	{
	int i;
        char c;
      
	soc = open_sock_tcp(args, 23);
        if(soc < 0)return(0);
        c = init_telnet_session(soc);
        if(c < 0 )return(0);
	buf = emalloc(1024);
	recv(soc, buf+1, 1024,0);
        buf[0]=c;
	for(i=0;i<strlen(buf);i++)buf[i] = tolower(buf[i]);
	if(strstr(buf, "hp jetdirect")&&!strstr(buf, "password"))
        {
	post_hole(args,23,
	
"The remote printer has no password set. Anyone can\n\
telnet to it and change its IP, thus resulting in \n\
the creation of serious network conflicts.\n\n\
Solution: telnet to this printer and issue the 'passwd'\n\
command");
        }
	efree(&buf);
	socket_close(soc);
	}
	return(0);
}



char init_telnet_session(int sock)
{ 
 unsigned char iac, code, option;
 

 iac = 255;
 
 while(iac == 255)
 {
   fd_set read;
   struct timeval tv = {5,0};
   
   FD_ZERO(&read);
   FD_SET(sock, &read);
   select(sock+1, &read, NULL, NULL, &tv);
   if(!FD_ISSET(sock, &read))return(-1);
   recv(sock, &iac, 1,0);
   if(iac!=255)break;
   recv(sock, &code, 1,0);
   recv(sock, &option, 1,0);
   if((code == 251)||(code == 252))code = 254; /* WILL or WONT --> DONT */
   else if((code == 253)||(code == 254))code = 252; /* DO or DON'T --> WONT */
   send(sock, &iac, 1,0);
   send(sock,&code, 1,0);
   send(sock, &option, 1,0);
  }
  return(iac);
}
