#ifndef HOSTLOOP_ICMP_H
#define HOSTLOOP_ICMP_H



#if !defined(HAVE_STRUCT_IP) || (HAVE_STRUCT_IP == 0)

struct ip {
#ifdef _IP_VHL
	u_char	ip_vhl;			/* version << 4 | header length >> 2 */
#else
#if !WORDS_BIGENDIAN || defined(NESSUSNT)
	u_char	ip_hl:4,		/* header length */
		ip_v:4;			/* version */
#endif
#if WORDS_BIGENDIAN && !defined(NESSUSNT)
	 u_char	ip_v:4,			/* version */
		ip_hl:4;		/* header length */
#endif
#endif /* not _IP_VHL */
	u_char	ip_tos;			/* type of service */
	u_short	ip_len;			/* total length */
	u_short	ip_id;			/* identification */
	u_short	ip_off;			/* fragment offset field */
#define	IP_RF 0x8000			/* reserved fragment flag */
#define	IP_DF 0x4000			/* dont fragment flag */
#define	IP_MF 0x2000			/* more fragments flag */
#define	IP_OFFMASK 0x1fff		/* mask for fragmenting bits */
	u_char	ip_ttl;			/* time to live */
	u_char	ip_p;			/* protocol */
	u_short	ip_sum;			/* checksum */
	struct	in_addr ip_src,ip_dst;	/* source and dest address */
};

#endif /* not defined(HAVE_STRUCT_IP) */


#if !defined(HAVE_STRUCT_ICMP) || (HAVE_STRUCT_ICMP == 0)
struct icmp_ra_addr {
	u_int32_t ira_addr;
	u_int32_t ira_preference;
};


struct icmp {
	u_char	icmp_type;		/* type of message, see below */
	u_char	icmp_code;		/* type sub code */
	u_short	icmp_cksum;		/* ones complement cksum of struct */
	union {
		u_char ih_pptr;			/* ICMP_PARAMPROB */
		struct in_addr ih_gwaddr;	/* ICMP_REDIRECT */
		struct ih_idseq {
			n_short	icd_id;
			n_short	icd_seq;
		} ih_idseq;
		int ih_void;

		/* ICMP_UNREACH_NEEDFRAG -- Path MTU Discovery (RFC1191) */
		struct ih_pmtu {
			n_short ipm_void;
			n_short ipm_nextmtu;
		} ih_pmtu;

		struct ih_rtradv {
			u_char irt_num_addrs;
			u_char irt_wpa;
			u_int16_t irt_lifetime;
		} ih_rtradv;
	} icmp_hun;
#define	icmp_pptr	icmp_hun.ih_pptr
#define	icmp_gwaddr	icmp_hun.ih_gwaddr
#define	icmp_id		icmp_hun.ih_idseq.icd_id
#define	icmp_seq	icmp_hun.ih_idseq.icd_seq
#define	icmp_void	icmp_hun.ih_void
#define	icmp_pmvoid	icmp_hun.ih_pmtu.ipm_void
#define	icmp_nextmtu	icmp_hun.ih_pmtu.ipm_nextmtu
#define	icmp_num_addrs	icmp_hun.ih_rtradv.irt_num_addrs
#define	icmp_wpa	icmp_hun.ih_rtradv.irt_wpa
#define	icmp_lifetime	icmp_hun.ih_rtradv.irt_lifetime
	union {
		struct id_ts {
			n_time its_otime;
			n_time its_rtime;
			n_time its_ttime;
		} id_ts;
		struct id_ip  {
			struct ip idi_ip;
			/* options and then 64 bits of data */
		} id_ip;
		struct icmp_ra_addr id_radv;
		u_long	id_mask;
		char	id_data[1];
	} icmp_dun;
#define	icmp_otime	icmp_dun.id_ts.its_otime
#define	icmp_rtime	icmp_dun.id_ts.its_rtime
#define	icmp_ttime	icmp_dun.id_ts.its_ttime
#define	icmp_ip		icmp_dun.id_ip.idi_ip
#define	icmp_radv	icmp_dun.id_radv
#define	icmp_mask	icmp_dun.id_mask
#define	icmp_data	icmp_dun.id_data
};

#endif /* not defined(HAVE_STRUCT_ICMP) */

#ifndef HAS_ICMP_ICMP_LIFETIME
#define SET_ICMP_LIFETIME(x,y) (x).icmp_hun.ih_void = (x).icmp_hun.ih_void & y
#else
#define SET_ICMP_LIFETIME(x,y) (x).icmp_lifetime = y
#endif
int in_cksum(u_short *, int);
int is_host_alive(struct in_addr ip);


#endif
