/*
 * 
 * wingate
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h> 


#define NAME "HP JetDirect TCP/IP problems: single thread"
#define DESC "\
See the ISS Security Advisory of the same name\n\
Basically, the older JetDirect interfaces have several\n\
problems.\n\
One of them is the fact that the HP JetDirect is single-threaded\n\
so when one of the ports is occupied, the other ports are unavailable.\n\
The consequence of this problem is that the printer can't emulate\n\
properly the spooler caracteristics.\n\
This can allow a malicious user to prevent other people from\n\
printing their work.\n\
Risk factor: Low"

#define COPYRIGHT "based on the ISS Security Advisory of the same name"
#define SUMM "checks if anyone can cause a DoS of the printer via the single threaded\
 architecture of the printer"


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "Misc.");
	return(0);
}


char init_telnet_session(int sock);
PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	int soc;
	char * buf;
	if(host_get_port_state(args, 23))
	{
	int i;
        char c;
      
	soc = open_sock_tcp(args, 23);
        if(soc < 0)return(0);
        c = init_telnet_session(soc);
        if(c < 0)return(0);
	buf = emalloc(1024);
	recv(soc, buf+1, 1024,0);
        buf[0]=c;
	for(i=0;i<strlen(buf);i++)buf[i] = tolower(buf[i]);
	if(strstr(buf, "hp jetdirect"))
        {
         shutdown(soc, 2);
         close(soc);
         soc = open_sock_tcp(args, 515);
         if(soc > 0)
         {
          int soc2;
          shutdown(soc, 2);
          close(soc);
          soc = open_sock_tcp(args, 23);
          soc2 = open_sock_tcp(args, 515);
          if((soc > 0) && (soc2 < 0))
          {
           post_info(args, 515, "\
The remote HP LaserJet printer is\n\
single threaded, so it is subject to\n\
the bugs described in the ISS Security\n\
advisory called \"HP JetDirect TCP/IP problems\"\n\n\
Solution : contact your vendor for a fix");
 	  }
          shutdown(soc2, 2);
          shutdown(soc, 2);
         }
	}
        }
	return(0);
}


char init_telnet_session(int sock)
{ 
 unsigned char iac, code, option;
 

 iac = 255;
 
 while(iac == 255)
 {
   fd_set read;
   struct timeval tv = {5,0};
   
   FD_ZERO(&read);
   FD_SET(sock, &read);
   select(sock+1, &read, NULL, NULL, &tv);
   if(!FD_ISSET(sock, &read))return(-1);
   recv(sock, &iac, 1,0);
   if(iac!=255)break;
   recv(sock, &code, 1,0);
   recv(sock, &option, 1,0);
   if((code == 251)||(code == 252))code = 254; /* WILL or WONT --> DONT */
   else if((code == 253)||(code == 254))code = 252; /* DO or DON'T --> WONT */
   send(sock, &iac, 1,0);
   send(sock,&code, 1,0);
   send(sock, &option, 1,0);
  }
  return(iac);
}
