/*
 * 
 * lpd
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h> 


#define NAME "lpd is active"
#define DESC "\
Some badly configured line printer daemons (lpd)\n\
allow anyone to use the printer they are in charge of.\n\
This may allow an attacker to cause denials of service\n\
by filling the printer queue, or to waste paper and ink.\n\
\nRisk factor : medium"
#define COPYRIGHT "no copyright"
#define SUMM "notifies the user that lpd is available"


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "Misc.");
	return(0);
}



PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	int soc;
	int behind_firewall = 0;
        char * pref = get_preference(args, "outside_firewall");
        
        if(pref)if(!strcmp(pref, "yes"))behind_firewall = 1;
        
	if(host_get_port_state(args, 515))
	{
	int i;
	soc = open_sock_tcp(args, 515);
	if(soc != -1)
        {
        if(!behind_firewall)
	 post_info(args,515,
	
"You should check that the remote printer service (lpd)\n\
is correctly configured to accept print requests only\n\
from a restricted panel of hosts");
	else
          post_hole(args, 515,
"The remote printer service (lpd) is not filtred \n\
by the firewall. You should : \n\
a) make sure that it only accepts requests from\n\
a restricted panel of hosts\n\
b) block the incoming connections coming from the\n\
outside and going to this service");
	shutdown(soc, 2);
	socket_close(soc);
	}
       }
	return(0);
}

