/*
 * 
 * nfs_world_export
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>

#define NAME "nfs world export"
#define DESC "\
Some servers exports any file to anybody, and it's usually not\n\
a good thing to do\n\n\
Risk factor : high"
#define COPYRIGHT "no copyright"
#define SUMM "check if a host exports a filesystem to anyone"


extern int showmount(char *hostname, char **result);


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_ATTACK);
	plug_set_family(desc, "Remote file access");
        plug_set_timeout(desc, 20);
	return(0);
}
	

PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
  int res;
  char * data;
  
 if(host_get_port_state(args, 2049)<=0)return(0);
 if(plug_get_key(args, "rpc/portmapper")&&
     (strlen(plug_get_key(args, "rpc/portmapper"))<3))return(0);
  res = !(showmount((char *)plug_get_hostname(args), &data));
  if (res)
  {
   if (strstr(data, "(everyone)"))
   	{
   	char * report = emalloc(strlen(data)+50);
   	sprintf(report, "Some filesystems are exported to __everyone__\n%s", data);
   	post_hole(args, 2049,report);
   	efree(&report);
   	efree(&data);
  }
 else if(!strlen(data))
 	{
         post_info(args, 2049, "The remote NFS server is superfluous : \n\
no filesystem are exported on the remote host\n\
Solution : disable it");
        }
  }
  return(0);
}
