/*
 * 
 * nis_server
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>

#ifdef HAVE_RPC_RPC_H
#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h>
#endif

#define YPSERV_RPC 100004
#define NAME "NIS server"
#define DESC "\
The NIS service is mainly used to share password\n\
files among the hosts of a given network. These files\n\
must not be intercepted by the intruders.\n\
The first step of their attack is to find out whether the\n\
host they are attacking is a NIS server. This plugin\n\
will attempt to see if the remote host is a NIS server.\n\n\
Risk factor : medium"
#define SUMM "determines if the remote host is a NIS server"
#define COPYRIGHT "distributed under the GPL"

PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_ATTACK);
	plug_set_family(desc, "NIS");
	return(0);
}

PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
 if(plug_get_key(args, "rpc/portmapper")&&
     (strlen(plug_get_key(args, "rpc/portmapper"))<3))return(0);
 if (callrpc (plug_get_hostname(args), YPSERV_RPC, -1, 0,
                       (xdrproc_t) xdr_void, (caddr_t) NULL,
                       (xdrproc_t) xdr_void, (caddr_t) NULL)==9)
 {
  char * pref = get_preference(args, "outside_firewall");
  if(strcmp(pref, "yes"))
  {
   post_info_udp(args, -1, "\
The remote host is a NIS server. You should\n\
use a firewall to filter incoming traffic to\n\
the port 111 of the remote host");
 }
 else 
  post_info_udp(args, -1, "\
The remote host is a NIS server. Your firewall\n\
should block all incoming traffic to port 111");
 }
 return(0);
}

