#define LEN_HDR_IP	20
#define LEN_HDR_UDP	8
#define LEN_HDR_RPC	24
#define LEN_AUTH_UNIX   72+12		/* length authentification field
					(credentials=null) plus
					 length hostname%4 ("localhost") */

#define ROUND_VALUE(value) (value/4+(value%4?1:0))

static int ctimeout;
static int verbose=0;

struct ip_hdr				
{
        unsigned char      ver;
        unsigned char      tos;
        unsigned short int length;
        unsigned short int identification;
        unsigned short int fragoff;
        unsigned char      ttl;
        unsigned char      protocol;
        unsigned short int checksum;
        unsigned long  int sip;
        unsigned long  int dip;
};

struct udp_hdr				
{
	unsigned short int sport;
	unsigned short int dport;
	unsigned short int length;
	unsigned short int checksum;
};

/*  RPC common hdr  */

struct rpc_hdr				
{       unsigned long  xid;
        unsigned long  type_msg;
        unsigned long  version_rpc;
        unsigned long  prog_id;
        unsigned long  prog_ver;
        unsigned long  prog_proc;
};

// RPC pcnfsd call args

struct pr_cancel_args			
{
	unsigned long  len_pn;
	char           printername[64];
	unsigned long  len_clnt;
	char           name[64];
	unsigned long  len_username;
	char           username[64];
	unsigned long  len_printerjobid;
	char           printerjobid[255];
	unsigned long  len_comments;
	char           comments[255];
};
#define LEN_HDR_PCN_CANCEL	sizeof(struct pr_cancel_args)

struct pr_mapid_args
{
        unsigned long  len_comments;
	char           comments[255];
        unsigned long  req_list;
	unsigned long  mapreq;
	unsigned long  uid;
	unsigned long  len_username;
	char           username[64];
	unsigned long  mapreqnext;		
};
#define LEN_HDR_PCN_MAPID	sizeof(struct pr_mapid_args)

struct pr_auth_args
{
	unsigned long  len_clnt;
	char           name[64];
	unsigned long  len_id;
	char           id[32];
        unsigned long  len_passwd;
        char           passwd[64];
        unsigned long  len_comments;
	char           comments[255];
};
#define LEN_HDR_PCN_AUTH	sizeof(struct pr_auth_args)

struct pr_init_args {
        unsigned long  len_clnt;
        char           name[64];
        unsigned long  len_pn;
        char           printername[64];
        unsigned long  len_comments;
        char           comments[255];
};
#define LEN_HDR_PCN_INIT        sizeof(struct pr_init_args)

struct pr_info_args {
	unsigned long  len_version;
	char           version[255];
	unsigned long  len_comments;
	char           comments[255];
};
#define LEN_HDR_PCN_INFO        sizeof(struct pr_info_args)
