/*
 * pcnfsd_warning
 *
 *
 */
 
#include <includes.h>



#define NAME "pcnfsd warning"
#define DESCRIPTION "\
A lot of security problems have been found with\n\
pcnfsd, so any admin who feels concerned by\n\
security should disable this service as soon\n\
as possible.\n\
Some versions of pcnfsd allow a remote user to\n\
gain root privileges, to chmod() some files and\n\
so on...\n\
Risk factor : high"
#define COPYRIGHT "no copyright"
#define SUMMARY "warns the user that pcnfsd is running"

#define PCNFSD_PROG 150001



PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESCRIPTION);
  plug_set_summary(desc, SUMMARY);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_ATTACK);
  plug_set_family(desc, "RPC programs");
  plug_set_timeout(desc, 10);
  return(0);
}

PlugExport int plugin_run(struct arglist * env);
PlugExport int plugin_run(struct arglist * env)
{
  int port = 0;
  char * list, * report;
  struct in_addr * addr = plug_get_host_ip(env);
  if(plug_get_key(env, "rpc/portmapper")&&
     (strlen(plug_get_key(env, "rpc/portmapper"))<3))return(0);
  if(!addr)return(0);
  port = getrpcport(plug_get_hostname(env), PCNFSD_PROG, 2, IPPROTO_UDP);
  if(!port)return(0);
  else 
    {
    post_hole_udp(env, port,
"pcnfsd is running. A lot of problems have been found\n\
with it, so you should really consider disabling this\n\
service and replace it by something else");
    }
  return(0);
}
 



