/*
 * 
 * pop3_overflow
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>

#define NAME "pop3 buffers overflows"
#define DESC "\
There's a bug on some versions of pop3d which allow a remote user\n\
to become root using a buffer overflow\n\
This plugin determines if the remote pop3d is subject to this\n\
attack\n\n\
Risk factor : high"
#define COPYRIGHT "no copyright"
#define SUMM "pop3 buffers overflows"


static const char * commands[] = { "auth", "user", "pass", "apop", "rpop" };
#define NUM_COMMANDS 5

PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESC);
  plug_set_summary(desc, SUMM);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_GATHER_INFO);
  plug_set_family(desc, "Gain root remotely");
  return(0);
}


PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
  if(host_get_port_state(args, 110)>0)
    {
      int soc;
	  char * buf = emalloc(1024);
	  char * command;
          int i;
          
          command = emalloc(2048);
          memset(buf, 'A', 1023);
	 for(i=0;i<NUM_COMMANDS;i++)
	 {
          soc = open_sock_tcp(args, 110);
          if(soc < 0)continue;
	  recv_line(soc, buf, 1024);
	  bzero(command, 2048);
	  sprintf(command, "%s %s\nPASS test\n", commands[i], buf);
	  send(soc, command, strlen(command),0);
#ifndef NESSUS_NT
	      signal(SIGPIPE, SIG_IGN);
#endif
	  recv_line(soc, command, 1024);
	      if(!strlen(command))
		{
		  char * report = emalloc(1024);
		  sprintf(report,
			  "The remote POP server appears to be subjet to a buffer overrun attack\n\
when the command '%s' is issued. This may allow remote users to become\n\
root easily\n\n\
Solution: contact your vendor for a patch", commands[i]);
		  post_hole(args, 110, report);
		  efree(&report);
		}
           shutdown(soc, 2);
           socket_close(soc);
	  }
	  efree(&buf);
	  efree(&command);
	  
	}
  return(0);
}
