/*
 * tooltalk
 *
 * This plugin is distributed under the GPL
 */


#include <includes.h>
#ifdef HAVE_RPC_RPC_H
#include <rpc/rpc.h>
#include <rpc/pmap_prot.h>
#endif


#define NAME "Portmapper check"
#define DESC "\
The portmapper is the central program for RPC\n\
programs. If an attacker can connect to it, he\n\
can find which RPC services are running and\n\
can make a more accurate attack.\n\
Risk factor : Medium"
#define SUMMARY "checks if the RPC portmapper is available"
#define COPYRIGHT "no copyright"

PlugExport int plugin_init(struct arglist * desc);
PlugExport int plugin_init(struct arglist * desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESC);
  plug_set_summary(desc, SUMMARY);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_GATHER_INFO);
  plug_set_family(desc, "RPC programs");
  plug_set_timeout(desc, 10);
  return(0);
}



PlugExport int plugin_run(struct arglist * env);
PlugExport int plugin_run(struct arglist * env)
{
 struct sockaddr_in addr;
 struct in_addr * a = plug_get_host_ip(env);
 if(!a)return(0);
 addr.sin_addr.s_addr = a->s_addr;
 addr.sin_port = htons(111);
 addr.sin_family = AF_INET;
 
 if (pmap_getmaps(&addr))
 {
  plug_set_key(env, "rpc/portmapper", ARG_STRING, "yes");
  post_info_udp(env, 111, "\
We could connect to the remote\n\
RPC portmapper. This can give away\n\
interesting informations to an attacker\n\
Solution : filter incoming traffic to this\n\
port");
 }
 else plug_set_key(env, "rpc/portmapper", ARG_STRING, "no");
 return(0);
}
