/*
 * 
 * proxy_check
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>
#define NAME "Proxy GET check"
#define DESC "Some misconfigured proxies accept requests like\n\
asking some non-WWW ports (ie: 25). This is a security flaw since\n\
it allows the anonymous redirection of connections. This plugin\n\
checks if : \n\
a) The remote proxy accepts our requests (which may be a bad thing)\n\
b) The remote proxy accepts our requests on bogus ports\n\
If the remote proxy accepts requests on bogus ports, this may allow\n\
an attacker to bypass a firewall.\n\n\
Risk factor : very high"
#define COPYRIGHT "Renaud Deraison <deraison@worldnet.fr>"
#define SUMM "checks for badly configured proxies"




PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_ATTACK);
	plug_set_family(desc, "Firewalls");
	return(0);
}


PlugExport int plugin_run(struct arglist * env);
PlugExport int plugin_run(struct arglist * env)
{
 int port = -1;
 int access = 0;
 int ports = 0;
 if(host_get_port_state(env, 3128)>0)port = 3128;
 else if(host_get_port_state(env, 8080)>0)port = 8080;
 else if(host_get_port_state(env, 80)>0)port = 80;
 
 
 if(port>0)
 {
  int soc = open_sock_tcp(env, port);
  char * our_host = emalloc(255);
  struct in_addr our_ip;
  struct hostent * he;
  
  if((soc < 0)&&(port == 3128)){
   port = 8080;
   soc = open_sock_tcp(env,port);
   if(soc < 0){
     port=80;
     soc = open_sock_tcp(env, port);
     }
  }
  if(soc < 0)return(0);
  gethostname(our_host, 254);
  our_ip = nn_resolve(our_host);
  he = gethostbyaddr((char *)&our_ip, sizeof(long), AF_INET);
  if(he){
   our_host = emalloc(strlen(he->h_name)+1);
   strncpy(our_host, he->h_name, strlen(he->h_name));
   }
  
 access = check_proxy_access(env, soc, our_host);
 shutdown(soc, 2);
 close(soc);
 soc = open_sock_tcp(env, port);
 ports = check_proxy_ports(env, soc, our_host);
  
 if(ports)
 {
  char * report = emalloc(1024);
sprintf(report,"The remote proxy accepted the request : \n\
GET http://%s:25 HTTP/1.1\n\
This means that anyone can use it to connect\n\
anonymously anywhere.\n\
Solution : edit the proxy config file and deny\n\
all the ports except 80 and 21 (ftp)", our_host);

  post_hole(env, port, report);
  efree(&report);
 }
 else if(access)
 {
  char * report = emalloc(1024);
  sprintf(report,
"The remote proxy allowed us to use its cache\n\
If we are doing the test through an untrusted host,\n\
this is a bad thing, else forget this warning");

  post_info(env, port, report);
  efree(&report);
  }
  efree(&our_host);
  }
  
  return(0);
}


int check_proxy_access(env, soc, our_host)
 struct arglist * env;
 int soc;
 char * our_host;
{
 char * buffer = emalloc(255);
 int err;
 char * c[2];
 int result = 0;
 int i;
 sprintf(buffer, "GET http://%s HTTP/1.0\n\n", our_host);
 send(soc, buffer, strlen(buffer), 0);
 bzero(buffer, strlen(buffer));
 
 recv_line(soc, buffer, 255);
 c[0] = emalloc(strlen(buffer)+1);
 c[1] = emalloc(strlen(buffer)+1);
 sscanf(buffer, "%s %d %s", c[0], &err, c[1]);
  for(i=0;i<strlen(buffer);i++)buffer[i]=tolower(buffer[i]);
 if((err == 400)&&(strstr(buffer, "denied")))i = 0;
 else i = 1;
 efree(&c[0]);
 efree(&c[1]);
 
 if((err == 200)||((err == 400)&&(i==1)))result = 1;
 else result = 0;
 efree(&buffer);
 return(result);
}



int check_proxy_ports(env, soc, our_host)
 struct arglist * env;
 int soc;
 char * our_host;
{
 char * buffer = emalloc(255);
 int err;
 char * c[2];
 int result = 0;
 int i;
 

 sprintf(buffer, "GET http://%s:25 HTTP/1.0\n\n", our_host);
 send(soc, buffer, strlen(buffer), 0);
 bzero(buffer, strlen(buffer));
 
 recv_line(soc, buffer, 255);
 c[0] = emalloc(strlen(buffer)+1);
 c[1] = emalloc(strlen(buffer)+1);
 for(i=0;i<strlen(buffer);i++)buffer[i]=tolower(buffer[i]);
 sscanf(buffer, "%s %d %s", c[0], &err, c[1]);
 if((err == 400)&&(strstr(buffer, "denied")))i = 0;
 else i = 1;
 efree(&c[0]);
 efree(&c[1]);
 
 if((err == 200)||((err == 400)&&(i==1)))result = 1;
 else result = 0;
 efree(&buffer);
 return(result);
}
