/*
 * R-commands
 * 
 * This plugin checks if the remote computer rservices are
 * activated... If they are and if it is supposed to be
 * behind a firewall, this is a bad thing...
 */
 
#include <includes.h>
#define NAME "r-commands check"
#define DESC "\
Some people install a proxy which is supposed\n\
to act as a firewall, and feel safe, even though\n\
they have not disabled the r-commands (rlogin, rsh...)\n\
This plugin checks that the rservices of a \n\
firewall protected computer are unavailable\n\n\
Risk factor : high"

#define SUMM "checks the presence of the r-commands (rsh,rlogin...)"
#define COPYRIGHT "Licensed under the GPL"


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
        plug_set_name(desc, NAME);
        plug_set_description(desc, DESC);
        plug_set_summary(desc, SUMM);
        plug_set_copyright(desc, COPYRIGHT);
        plug_set_category(desc, ACT_GATHER_INFO);
        plug_set_family(desc, "Firewalls");
        return(0);
}

PlugExport int plugin_run(struct arglist * desc);
PlugExport int plugin_run(struct arglist * desc)
{
 char * c = get_preference(desc, "outside_firewall");
 int s;
 
 if(strcmp(c, "yes"))return(0);

 if((s=open_sock_tcp(desc, 514))!=-1)
 {
  post_hole(desc, 514,
"The rsh service is activated, even though\n\
the remote host is firewall protected.\n\
Disable the 'shell' entry in inetd.conf");
 shutdown(s, 2);
 close(s);
 }
 
 if((s=open_sock_tcp(desc, 513))!=-1)
 {
  post_hole(desc, 513,
"The rlogin service is activated, even though\n\
the remote host is firewall protected.\n\
Disable the 'login' entry in inetd.conf");
 shutdown(s, 2);
 close(s);
 }
 
 if((s=open_sock_tcp(desc, 512))!=-1)
 {
  post_hole(desc, 512, 
"The rexec service is activated, even though\n\
the remote host is firewall protected.\n\
Disable the 'exec' entry in inetd.conf");
shutdown(s, 2);
 close(s);
 }
 
 return(0);
}
