/*
 * rexecd
 * 
 */
 
#include <includes.h>
#define NAME "rexecd check"
#define DESC "\
Because rexec uses unprivileged ports for the\n\
whole process, any user can send a request to a\n\
rexecd requesting connection of the stderr stream\n\
to an arbitrary port on the client machine.\n\
Since the client is unprivileged, there is no\n\
possibility for the legitimate stderr stream to be\n\
destined for a privileged port.\n\
In addition, spoofing techniques could allow the\n\
client to direct the stderr stream towards an arbitrary\n\
host as well as an arbitrary port, possibly exploiting\n\
a given trust model.\n\
Since rexecd terminates if the stderr port can't be\n\
connected to, and the port can be specified, rexecd can\n\
be used to easily scan the client host from the server host.\n\
Risk factor : medium"

#define SUMM "checks for the precence of the rexec service"
#define COPYRIGHT "Licensed under the GPL"


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
        plug_set_name(desc, NAME);
        plug_set_description(desc, DESC);
        plug_set_summary(desc, SUMM);
        plug_set_copyright(desc, COPYRIGHT);
        plug_set_category(desc, ACT_GATHER_INFO);
        plug_set_family(desc, "Misc.");
        return(0);
}

PlugExport int plugin_run(struct arglist * desc);
PlugExport int plugin_run(struct arglist * desc)
{
 int s;
 if((s=open_sock_tcp(desc, 512))!=-1)
 {
  post_hole(desc, 512,
"The rexecd service is activated. This may\n\
allow someone to use your computer to\n\
scan someone else's, and this can \n\
create more security problems (see\n\
the 'Misc./rexecd' plugin for more\n\
details)\n\
Solution : disable this service in inetd.conf"); 
 shutdown(s, 2);
 close(s);
 }
 return(0);
}
