
#include <includes.h>



#define NAME "keyserv service"
#define DESCRIPTION "\
The keyserv service is a RPC service\n\
which may cause some problems. If you do not\n\
use it, you should disable it.\n\
This service is necessary to exploit some\n\
holes in some other RPC services (like\n\
ypupdated), so it is one more reason to\n\
disable it\n\
Risk factor : low/medium"
#define COPYRIGHT "no copyright"
#define SUMMARY "warns the user that the keyserv service is running"

#define RPC_PROG 100029



PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESCRIPTION);
  plug_set_summary(desc, SUMMARY);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_ATTACK);
  plug_set_family(desc, "RPC programs");
  plug_set_timeout(desc, 5);
  return(0);
}

PlugExport int plugin_run(struct arglist * env);
PlugExport int plugin_run(struct arglist * env)
{
  int port = 0;
  int tcp = 0;
  if(plug_get_key(env, "rpc/portmapper")&&
     (strlen(plug_get_key(env, "rpc/portmapper"))<3))return(0);
  port = getrpcport(plug_get_hostname(env), RPC_PROG, -1, IPPROTO_UDP);
  if(!port){
   port = getrpcport(plug_get_hostname(env), RPC_PROG, -1, IPPROTO_TCP);
   tcp++;
   }
  if(port)
    {
    char * report = "the keyserv RPC service is running.\n\
If you do not use it, disable it.";
    if(!tcp)post_info_udp(env, port,report);
    else post_info(env, port, report);
    }
  return(0);
}
 



