
#include <includes.h>



#define NAME "rexd service"
#define DESCRIPTION "\
If rexd is running any intruder using a program\n\
emulating the 'on' command may gain a shell access\n\
to the attacked system.\n\
This plugin determines if rexd is running.\n\
Risk factor : High"
#define COPYRIGHT "no copyright"
#define SUMMARY "warns the user that the rexd service is running"

#define RPC_PROG 100017



PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESCRIPTION);
  plug_set_summary(desc, SUMMARY);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_ATTACK);
  plug_set_family(desc, "RPC programs");
  plug_set_timeout(desc, 5);
  return(0);
}

PlugExport int plugin_run(struct arglist * env);
PlugExport int plugin_run(struct arglist * env)
{
  int port = 0;
  int tcp = 0;
  if(plug_get_key(env, "rpc/portmapper")&&
     (strlen(plug_get_key(env, "rpc/portmapper"))<3))return(0);
  port = getrpcport(plug_get_hostname(env), RPC_PROG, -1, IPPROTO_UDP);
  if(!port){
   port = getrpcport(plug_get_hostname(env), RPC_PROG, -1, IPPROTO_TCP);
   tcp++;
   }
  if(port)
    {
    char * report = "the rexd RPC service is running.\n\
This may give a shell access to any\n\
intruder(see CA-92:05.AIX.REXD.Daemon.vulnerability)\n\
Solution : disable this service in /etc/inetd.conf\n";
    if(!tcp)post_hole_udp(env, port,report);
    else post_hole(env, port, report);
    }
  return(0);
}
 



