
#include <includes.h>



#define NAME "rstatd service"
#define DESCRIPTION "\
The rstatd service is a RPC provides to \n\
the intruder several interesting informations : \n\
- the uptime of the machine\n\
- its number of hard drives\n\
- its CPU usage\n\
- its network usage (number of packets\n\
  that have reached it)\n\
So, it is usually not a good idea to let this\n\
service open to the world\n\
Risk factor : low"
#define COPYRIGHT "no copyright"
#define SUMMARY "warns the user that the rstatd service is running"

#define RPC_PROG 100001



PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESCRIPTION);
  plug_set_summary(desc, SUMMARY);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_ATTACK);
  plug_set_family(desc, "RPC programs");
  plug_set_timeout(desc, 5);
  return(0);
}

PlugExport int plugin_run(struct arglist * env);
PlugExport int plugin_run(struct arglist * env)
{
  int port = 0;
  int tcp = 0;
  if(plug_get_key(env, "rpc/portmapper")&&
     (strlen(plug_get_key(env, "rpc/portmapper"))<3))return(0);
  port = getrpcport(plug_get_hostname(env), RPC_PROG, -1, IPPROTO_UDP);
  if(!port){
   port = getrpcport(plug_get_hostname(env), RPC_PROG, -1, IPPROTO_TCP);
   tcp++;
   }
  if(port)
    {
    char * report = "the rstatd RPC service is running.\n\
It usually gives away too many informations\n\
about the remote host to the intruder, so\n\
you should consider disable it...\n\
Fix : disable it in /etc/inetd.conf";
    if(!tcp)post_info_udp(env, port,report);
    else post_info(env, port, report);
    }
  return(0);
}
 



