
#include <includes.h>



#define NAME "selection service"
#define DESCRIPTION "\
Under SunOS running the  SunView windowing system, it  is possible\n\
to   remotely   access   files   using   SunView  selection_svc(1)\n\
subprocess  and  the  RPC  facility.  The  selection_svc   program\n\
handles  all  selections  made  by  SunView client programs. It is\n\
used to modify  resource files and  cut/paste selections. The  way\n\
these clients communicate with selection_svc is though RPC  calls.\n\
The problem is that the selection service process will accept  RPC\n\
requests   from   any   user,   both   locally   and  remotely.  No\n\
authentification is performed, so it is possible for a remote\n\
intruder to access your files.\n\
Risk factor : medium/high"
#define COPYRIGHT "no copyright"
#define SUMMARY "warns the user that the selection service is running"

#define RPC_PROG 100015



PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESCRIPTION);
  plug_set_summary(desc, SUMMARY);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_ATTACK);
  plug_set_family(desc, "RPC programs");
  plug_set_timeout(desc, 5);
  return(0);
}

PlugExport int plugin_run(struct arglist * env);
PlugExport int plugin_run(struct arglist * env)
{
  int port = 0;
  int tcp = 0;
  if(plug_get_key(env, "rpc/portmapper")&&
     (strlen(plug_get_key(env, "rpc/portmapper"))<3))return(0);
  port = getrpcport(plug_get_hostname(env), RPC_PROG, 6, IPPROTO_UDP);
  if(!port){
   port = getrpcport(plug_get_hostname(env), RPC_PROG, 6, IPPROTO_TCP);
   tcp++;
   }
  if(port)
    {
    char * report = "the selection_svc RPC service is running\n\
It may allow anyone to access any file on the remote\n\
system. ** We could not determine if this host is \n\
vulnerable **. If you have applied Sun patch 100085-03 \n\
it should not, or else it is.\n\
Fix : apply Sun patch 100085-03";
    if(!tcp)post_hole_udp(env, port,report);
    else post_hole(env, port, report);
    }
  return(0);
}
 



