
#include <includes.h>



#define NAME "walld service"
#define DESCRIPTION "\
The walld RPC service is usually used\n\
by the administrator to tell something\n\
to the users of the network by making a\n\
message appear on their screen.\n\
Since it lacks in authentification, this\n\
daemon can be used by an attacker to trick\n\
the users into doing something (social \n\
engineering).\n\
It can also be used as a denial of service\n\
attack by continually sending garbage to \n\
the users screens, preventing them from\n\
working.\n\
Risk factor : medium"
#define COPYRIGHT "no copyright"
#define SUMMARY "warns the user that the walld service is running"

#define RPC_PROG 100008



PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESCRIPTION);
  plug_set_summary(desc, SUMMARY);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_ATTACK);
  plug_set_family(desc, "RPC programs");
  plug_set_timeout(desc, 5);
  return(0);
}

PlugExport int plugin_run(struct arglist * env);
PlugExport int plugin_run(struct arglist * env)
{
  int port = 0;
  int tcp = 0;
  if(plug_get_key(env, "rpc/portmapper")&&
     (strlen(plug_get_key(env, "rpc/portmapper"))<3))return(0);
  port = getrpcport(plug_get_hostname(env), RPC_PROG, -1, IPPROTO_UDP);
  if(!port){
   port = getrpcport(plug_get_hostname(env), RPC_PROG, -1, IPPROTO_TCP);
   tcp++;
   }
  if(port)
    {
    char * report = "\
The walld RPC service is running and \n\
can be used by an attacker for doing\n\
social engineering and/or denial of service\n\
attacks.\n\
Solution : disable it in /etc/inetd.conf";
    if(!tcp)post_hole_udp(env, port,report);
    else post_hole(env, port, report);
    }
  return(0);
}
 



