
#include <includes.h>



#define NAME "ypupdated service"
#define DESCRIPTION "\
When ypupdated receives requests to update\n\
yp maps on a host machine it forks and executes\n\
a copy of the bourne shell. Through the bourne\n\
shell meta characters may be passed into the\n\
arguments causing a security breach.\n\
Risk factor : High"


#define COPYRIGHT "found by Avalon Security Research"
#define SUMMARY "warns the user that the ypupdated service is running"

#define RPC_PROG 100028



PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESCRIPTION);
  plug_set_summary(desc, SUMMARY);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_ATTACK);
  plug_set_family(desc, "RPC programs");
  plug_set_timeout(desc, 5);
  return(0);
}

PlugExport int plugin_run(struct arglist * env);
PlugExport int plugin_run(struct arglist * env)
{
  int port = 0;
  int tcp = 0;
  if(plug_get_key(env, "rpc/portmapper")&&
     (strlen(plug_get_key(env, "rpc/portmapper"))<3))return(0);
  port = getrpcport(plug_get_hostname(env), RPC_PROG, -1, IPPROTO_UDP);
  if(!port){
   port = getrpcport(plug_get_hostname(env), RPC_PROG, -1, IPPROTO_TCP);
   tcp++;
   }
  if(port)
    {
    char * report = "\
The ypupdated service is running.\n\
Some versions of ypupdated may be used\n\
by intruders to execute remotely any command\n\
with root priviledges.\n\
***This plugin did not check whether you were\n\
vulnerable or not!***. You should consult the\n\
CA-95:17.rpc.ypupdated.vul\n\
to determine what you should do.";
    if(!tcp)post_hole_udp(env, port,report);
    else post_hole(env, port, report);
    }
  return(0);
}
 



