/*
 *
 * This plugin has been written by Renaud Deraison
 * and is released under the GPL
 *
 */

#include <includes.h>

#define NAME "Sendmail supports EHLO"
#define DESC "\
The EHLO greeting indicates to sendmail to use ESMTP\n\
(Extended Simple Mail Transfer Protocol), which has\n\
additional vulnerabilities. Supporting it, and showing\n\
that sendmail supports it, may help an intruder to focus\n\
its efforts on a special weakness\n\
Risk factor : medium"
#define COPYRIGHT "distributed under the GPL"
#define SUMM "determines if the remote server supports EHLO greeting"

PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "Sendmail");
	return(0);
}
	

PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	int s,i;
	char * buff;
	
	if(host_get_port_state(args, 25)<=0)return(0);
	s = open_sock_tcp(args, 25);
	if(s<0)return(-1);
	buff = emalloc(1024);
	recv_line(s, buff, 1023);
        sprintf(buff, "EHLO domain.edu\n");
        write(s, buff, strlen(buff));
	recv_line(s, buff, 1023);
	if(!strncmp(buff, "250", 3))
	{
	post_info(args, 25,
"Sendmail supports the EHLO greetings, which means that \n\
it supports the ESMTP, which may be the source of additional\n\
security flaws that can be used by attackers.\n\
Solution : disable this feature in sendmail.conf");
 	}
        sprintf(buff,"quit\n");
        send(s, buff, strlen(buff),0);
        shutdown(s, 2);
        socket_close(s);
	efree(&buff);
	return(0);
}
