/*
 *
 * This plugin has been written by Renaud Deraison <deraison@nessus.org>
 * and is released under the GPL (Gnu Public License)
 *
 */

#include <includes.h>

#define NAME "Sendmail redirection attack"
#define DESC "\
Due to strange address parsing policy [briefly: if address ends with local\n\
hostname, trim it and parse as any other (even if after this operation\n\
address isn't 'local' anymore], specific message routing (eg. through\n\
internal, protected or external networks) can be forced, giving an\n\
occasion to perform anonymous scanning (or fakemailing). You could call\n\
it 'feature' instead of 'bug', but it seems to be Sendmail-specific ;>\n\
Simple fix - in /etc/sendmail.cf, at the top of ruleset 98, insert\n\
following line:\n\
R$*@$*@$*       $#error $@ 5.7.1 $: \"551 Sorry, no redirections.\"\n\
\n\nRisk factor : Low/Medium"
#define COPYRIGHT "Michal Zalewski <lcamtuf@IDS.PL>"
#define SUMM "check if specific message routing can be performed"

PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "Sendmail");
	return(0);
}
	

PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	int s,i;
	char * buff;
	char * domain;
        char * hostname;
	if(host_get_port_state(args, 25)<=0)return(0);
	s = open_sock_tcp(args, 25);
	if(s<0)return(-1);
	buff = emalloc(1024);
	recv_line(s, buff, 1023);
        hostname = (char *)plug_get_hostname(args);
        if(inet_addr(hostname)==INADDR_NONE)
        {
         domain = strchr(hostname, '.');
        }
        
        if(domain)domain++;
        else {
         	domain = emalloc(25);
                sprintf(domain, "nessus.org");
              }
        sprintf(buff, "HELO %s\n", domain);
        send(s, buff, strlen(buff), 0);
        recv(s, buff, 1024,0);
        if(!strncmp(buff, "250", 3))
        {
         bzero(buff, strlen(buff));
         sprintf(buff, "MAIL FROM: nessus\n");
         send(s, buff, strlen(buff), 0);
         recv(s, buff, 1024,0);
         if(!strncmp(buff, "250",3))
         {
          sprintf(buff, "RCPT TO: root@host1@host2\n");
          send(s, buff, strlen(buff), 0);
          recv(s, buff, 1024,0);
          if(!strncmp(buff, "250", 3))
          {
           post_info(args, 25, "\
The remote host is vulnerable to the sendmail\n\
specific message routing attack. Solution :\n\
in /etc/sendmail.cf, at the top of ruleset 98, insert\n\
following line:\n\
\n\
R$*@$*@$*       $#error $@ 5.7.1 $: \"551 Sorry, no redirections.\"");
	 }
        }
        }
        sprintf(buff,"quit\n");
        send(s, buff, strlen(buff),0);
        socket_close(s);
	efree(&buff);
	return(0);
}
