/*
 * 
 * pfdispaly
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>
#define NAME "shell interpreter"
#define DESC "\
Leaving executable shells in the cgi-bin directory\n\
of the remote web server can enable users to execute\n\
arbitrary commands on the target machine as the UID\n\
of the web server.\n\
This check checks for the following shells in your \n\
cgi-bin directory :\n\
ash\n\
bash\n\
csh\n\
ksh\n\
sh\n\
tcsh\n\
zsh\n\
Risk factor : High"

#define COPYRIGHT "no copyright"
#define SUMM "determines if there are executables shells in the remote cgi-bin/"

static int 
installed(data, cgi_name)
 struct arglist * data;
 char * cgi_name;
{
 char * command = emalloc(200);
 short soc=-1;
 short i=0;
 char * buff = emalloc(256);
  
 sprintf(command, "GET /cgi-bin/%s HTTP/1.0\nhostname: %s\n\n",
          cgi_name,  plug_get_hostname(data));
          
 soc = open_sock_tcp(data, 80);
 if(soc <0)return(0); /* couldn't open a connection */
 send(soc, command, strlen(command), 0);
 recv(soc, buff, 255,0);
 efree(&command);
 close(soc);
 
 if(strstr(buff, "HTTP/1.0 200 ") || strstr(buff, "HTTP/1.1 200 ") ||
   strstr(buff, "HTTP/1.0 500 ") || strstr(buff, "HTTP/1.1 500 "))i=1;
 else i = 0;
 efree(&buff);
 return(i);
}



PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_ATTACK);
	plug_set_family(desc, "CGI abuses");
	return(0);
}


PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	char *shells[]={"ash", "bash", "csh", "ksh", "sh", "tcsh", "zsh"};
        int num_shells = 7;
	int i;
        
        for(i=0;i<num_shells;i++)
	{
	if(installed(args, shells[i]))
        {
         char * report = emalloc(255);
         
         sprintf(report, "The shell %s is installed in the remote\n\
cgi-bin directory. This may allow anyone to execute\n\
any command on your web server.\n\
Solution: remove it", shells[i]);
	 post_hole(args, 80, report);
         efree(&report);
	}
        }
	return(0);
}

