/*
 * 
 * ssh_insertion
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>

#define NAME "SSH Insertion attack"
#define DESC "Older versions of the SSH protocol\n\
are vulnerable to an 'insertion attack'\n\
This means that an attacker with access to the\n\
encrypted SSH stream may insert encrypted blocks in the\n\
stream that will decrypt to arbitrary commands to be executed\n\
on the SSH server.\n\n\
Risk factor: High"
#define COPYRIGHT "Discovered by CORE SDI S.A <http://www.core-sdi.com>"
#define SUMM "checks for the version SSH protocol used on a remote machine"




PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESC);
  plug_set_summary(desc, SUMM);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_GATHER_INFO);
  plug_set_family(desc, "Misc.");
  return(0);
}


PlugExport int plugin_run(struct arglist * env);
PlugExport int plugin_run(struct arglist * env)
{
  int soc;
  char * data;
  char * t;
  if(!host_get_port_state(env, 22))return(0);
  
  soc = open_sock_tcp(env, 22);
  if(soc < 0)return(0);
  data = emalloc(255);
  recv_line(soc, data, 255);
  t = strchr(data, '-');
  if(t)
    {
      char * t2;
      char * t3;
      t+=sizeof(char);
      t2 = strchr(t, '-');
      t3 = t2;
      if(t2)
	{
	  int proto_version;
	  int proto_revision;
          int serv_version;
          int serv_revision;
          int serv_patch;
	  t2[0]=0;
	  t2 = strchr(t, '.');if(!t2)return(0);
	  t2[0] = 0;
	  t2+=sizeof(char);
	  proto_version = atoi(t);
	  proto_revision = atoi(t2);
          t3++;
          t2 = strchr(t3, '.');if(!t2)return(0);
          t2[0] = 0;
          serv_version = atoi(t3);
          t2++;
          t3 = strchr(t2, '.');if(!t3)return(0);
          t3[0] = 0;
          serv_revision = atoi(t2);
          t2 = t3+1;
          serv_patch = atoi(t2);
          
         
	  if(
            ((serv_version < 2)&&(serv_revision == 2)&&(serv_patch <= 25))||
          	((serv_version < 2) && (serv_revision < 2)))
	    {
	      post_hole(env, 22, 
			"The remote host may be vulnerable to the ssh insertion\n\
attack. This means that an attacker with access to the\n\
encrypted SSH stream may insert encrypted blocks in the\n\
stream that will decrypt to arbitrary commands to be executed\n\
on the SSH server.\n\
Solution : upgrade to the protocol version 2.0 or use version 1.2.25");
	    }
	}
    }
  efree(&data);
  return(0);
}
