/*
 * tooltalk
 *
 * This plugin is distributed under the GPL
 */


#include <includes.h>
#ifdef HAVE_RPC_RPC_H
#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h>
#endif

#define TOOLTALK_RPC 100083

#define NAME "Tooltalk presence check"
#define DESC "\
CERT Advisory CA-98.11 : \n\
An implementation fault in the ToolTalk object\n\
database server allows a remote attacker to run \n\
arbitrary code as the superuser on hosts supporting\n\
the ToolTalk service. The affected program runs on\n\
many popular UNIX operating systems supporting CDE\n\
and some Open Windows installs"
#define SUMMARY "check for the presence of the tooltalk RPC service"
#define COPYRIGHT "no copyright"

PlugExport int plugin_init(struct arglist * desc);
PlugExport int plugin_init(struct arglist * desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESC);
  plug_set_summary(desc, SUMMARY);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_ATTACK);
  plug_set_family(desc, "RPC programs");
  plug_set_timeout(desc, 10);
  return(0);
}



PlugExport int plugin_run(struct arglist * env);
PlugExport int plugin_run(struct arglist * env)
{
 if(plug_get_key(env, "rpc/portmapper")&&
     (strlen(plug_get_key(env, "rpc/portmapper"))<3))return(0);
 if (callrpc (plug_get_hostname(env), TOOLTALK_RPC, -1, 0,
		       (xdrproc_t) xdr_void, (caddr_t) NULL,
		       (xdrproc_t) xdr_void, (caddr_t) NULL) == 9)
 {
  int port;
  port = getrpcport(plug_get_hostname(env), TOOLTALK_RPC, -1, IPPROTO_UDP);
  if(!port)port = -1;
  post_hole_udp(env, port, "\
The remote host is running the tooltalk RPC\n\
service, which may be vulnerable (see the\n\
CERT advisory CA-98.11 tooltalk for details)\n");
 }
 return(0);
}
