/*
 * x11
 * 
 * This plugin has been written by Sebastion Schreiber and
 * is distributed under the GPL
 *
 * Changes:
 * 09/05/98 : Renaud Deraison <deraison@worldnet.fr> : cleaned up
 *            the includes and corrected some bugs
 *	      Changed the plugin family
 */

#include <includes.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>


#define NAME "X11-Checker"
#define DESC "Checks, if there is an open X11-Server\n\n\
Risk factor : high"
#define COPYRIGHT "Sebastian Schreiber, GPL"
#define SUMM "Determines if there is an X11-Server with disabled access control of the remote system"


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESC);
  plug_set_summary(desc, SUMM);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_GATHER_INFO);
  plug_set_family(desc, "Misc.");
  return(0);
}

PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
  char * hostname;
  char *report;
  Display * dpy;
  
  if(host_get_port_state(args, 6000)<=0)return(0);  
  hostname = emalloc(strlen(plug_get_hostname(args))+3);
  sprintf(hostname,"%s:0",plug_get_hostname(args));
  
  if ((dpy = XOpenDisplay(hostname)) != NULL){
    report = emalloc(1024);
    sprintf(report, 
 "On this machine, there is an X11-Server that grants access\n\
without authentification. That means a hacker is able to sniff\n\
every keystroke that is typed on the X11-Server (or get a copy of the victims screen).\n\
Solution: use MIT-Cookies, xauth. \n");
    post_hole(args, 6000, report);
    efree(&report);
    XCloseDisplay(dpy);
  }
  efree(&hostname);
  return(0);
}
